/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class IfParser
extends KeywordParserFactory {
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                Regex r = IfParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @if statement. Correct usage: @if (some-condition) {some-template-code}", new Object[0]);
                }
                String s = r.stringMatched(1);
                ctx.step(s.length());
                s = r.stringMatched(2);
                if (!s.endsWith("{")) {
                    s = "\n" + s + " {";
                }
                return new IfBlockCodeToken(s, ctx);
            }
        };
    }

    public Keyword keyword() {
        return Keyword.IF;
    }

    protected String patternStr() {
        return "(^%s(%s\\s*((?@()))(\\s*\\n*\\s*\\{)?)).*";
    }

    public static void main(String[] args) {
        String p = String.format(new IfParser().patternStr(), "@", "if");
        System.out.println(p);
        Regex r = new Regex(p);
        String s = "@if (\"TAB\".equalsTo(fbAuthMethod.toString())) {\n";
        if (r.search(s)) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
            System.out.println(r.stringMatched(2));
            System.out.println(r.stringMatched(3));
        }
    }

    public static class IfBlockCodeToken
    extends BlockCodeToken {
        public IfBlockCodeToken(String s, IContext context) {
            super(s, context);
        }
    }
}

