/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.resource;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.TemplateResourceBase;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class StringTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private String content;

    public StringTemplateResource(String templateContent) {
        this.content = templateContent;
    }

    public StringTemplateResource(String templateContent, RythmEngine engine) {
        super(engine);
        this.content = templateContent;
    }

    public String getKey() {
        return this.content;
    }

    public String asTemplateContent() {
        return this.content;
    }

    protected long lastModified() {
        return 0L;
    }

    public boolean isValid() {
        return true;
    }

    protected long defCheckInterval() {
        return -1L;
    }

    protected Long userCheckInterval() {
        return null;
    }

    protected String reload() {
        return this.content;
    }

    public String getSuggestedClassName() {
        try {
            return "C" + UUID.nameUUIDFromBytes(this.content.getBytes("utf-8")).toString().replace('-', '_');
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringTemplateResource) {
            StringTemplateResource that = (StringTemplateResource)obj;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }
}

