/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.runtime;

import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.Collection;
import java.util.Iterator;

public class Each {
    public static final Each INSTANCE = new Each();

    public void render(Iterable itr, IBody body) {
        this.loop(itr, body, -1);
    }

    public void render(Collection col, IBody body) {
        this.loop(col, body, col.size());
    }

    public void render(Object[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(items[i], size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void render(int[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(items[i], size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void render(long[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(items[i], size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void render(float[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(Float.valueOf(items[i]), size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void render(boolean[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(items[i], size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void render(char[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(Character.valueOf(items[i]), size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void render(double[] items, IBody body) {
        int size = items.length;
        body.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            boolean isOdd = i % 2 == 1;
            body.render(items[i], size, i, isOdd, isOdd ? "odd" : "even", i == 1, i == items.length);
        }
    }

    public void loop(Iterable itr, IBody body, int size) {
        Iterator it = itr.iterator();
        int start = 0;
        int i = 0;
        body.ensureCapacity(size);
        while (it.hasNext()) {
            Object o = it.next();
            boolean isOdd = ++i % 2 == 1;
            body.render(o, size, i, isOdd, isOdd ? "odd" : "even", i == start + 1, !it.hasNext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Looper<E>
    implements IBody<E> {
        private StringBuilder out = null;
        private int bodySize = 16;

        public Looper(TextBuilder tb) {
            this.out = tb.out();
        }

        public Looper(TextBuilder tb, int bodySize) {
            this.out = tb.out();
            this.bodySize = bodySize;
        }

        @Override
        public void ensureCapacity(int loopCnt) {
            int len = this.out.length();
            int delta = loopCnt * this.bodySize;
            this.out.ensureCapacity(len + delta);
        }

        protected String toString(Object o) {
            return null == o ? "" : o.toString();
        }

        private void p_(Object o) {
            String s = this.toString(o);
            if (!s.isEmpty()) {
                this.out.append(s);
            }
        }

        public final Looper p(Object o) {
            if (null != o) {
                this.out.append(o);
            }
            return this;
        }

        public final Looper p(String s) {
            if (null != s && !s.isEmpty()) {
                this.out.append(s);
            }
            return this;
        }

        protected final Looper pn(Object o) {
            if (null != o) {
                this.p_(o);
            }
            this.out.append('\n');
            return this;
        }

        protected final Looper pn(String s) {
            if (null != s && !s.isEmpty()) {
                this.out.append(s);
            }
            this.out.append("\n");
            return this;
        }

        protected final Looper np(Object o) {
            this.out.append('\n');
            if (null != o) {
                this.p_(o);
            }
            return this;
        }

        protected final Looper np(String s) {
            this.out.append("\n");
            if (null != s && !s.isEmpty()) {
                this.out.append(s);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBody<E> {
        public void render(E var1, int var2, int var3, boolean var4, String var5, boolean var6, boolean var7);

        public void ensureCapacity(int var1);
    }
}

