/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.template;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateBase
extends TextBuilder
implements ITemplate {
    protected transient RythmEngine engine = null;
    protected Map<String, Object> _properties = new HashMap<String, Object>();
    private String renderBody = "";
    private Map<String, String> renderSections = new HashMap<String, String>();
    private Map<String, Object> renderProperties = new HashMap<String, Object>();
    protected TemplateBase __parent = null;
    private StringBuilder tmpOut = null;
    private String section = null;
    private TextBuilder tmpCaller = null;
    private static final Pattern P = Pattern.compile(".*\\/\\/line:\\s*([0-9]+).*");
    protected static ILogger _logger = Logger.get(TemplateBase.class);

    protected RythmEngine _engine() {
        return null == this.engine ? Rythm.engine : this.engine;
    }

    protected void _invokeTag(String name) {
        this._engine().invokeTag(name, this, null, null);
    }

    protected void _invokeTag(String name, ITag.ParameterList params) {
        this._engine().invokeTag(name, this, params, null);
    }

    protected void _invokeTag(String name, ITag.ParameterList params, ITag.Body body) {
        this._engine().invokeTag(name, this, params, body);
    }

    public TemplateBase() {
        Class<?> c = this.getClass();
        Class<?> pc = c.getSuperclass();
        if (TemplateBase.class.isAssignableFrom(pc) && !Modifier.isAbstract(pc.getModifiers())) {
            try {
                this.__parent = (TemplateBase)pc.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final void setRenderBody(String body) {
        this.renderBody = body;
    }

    private void addRenderSection(String name, String section) {
        this.renderSections.put(name, section);
    }

    protected void _startSection(String name) {
        if (null == name) {
            throw new NullPointerException("section name cannot be null");
        }
        if (null != this.tmpOut) {
            throw new IllegalStateException("section cannot be nested");
        }
        this.tmpCaller = this._caller;
        this._caller = null;
        this.tmpOut = this._out;
        this._out = new StringBuilder();
        this.section = name;
    }

    protected void _endSection() {
        if (null == this.tmpOut && null == this.tmpCaller) {
            throw new IllegalStateException("section has not been started");
        }
        this.addRenderSection(this.section, this._out.toString());
        this._out = this.tmpOut;
        this._caller = this.tmpCaller;
        this.tmpOut = null;
        this.tmpCaller = null;
    }

    protected void _pSection(String name) {
        this.p(this.renderSections.get(name));
    }

    protected void _pBody() {
        this.p(this.renderBody);
    }

    private void addAllRenderSections(Map<String, String> sections) {
        if (null != sections) {
            this.renderSections.putAll(sections);
        }
    }

    private void addAllRenderProperties(Map<String, Object> properties) {
        if (null != properties) {
            this.renderProperties.putAll(properties);
        }
    }

    protected TemplateBase internalClone() {
        try {
            return (TemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public ITemplate cloneMe(RythmEngine engine, ITemplate caller) {
        if (null == engine) {
            throw new NullPointerException();
        }
        TemplateBase tmpl = this.internalClone();
        if (tmpl.__parent != null) {
            tmpl.__parent = (TemplateBase)tmpl.__parent.cloneMe(engine, caller);
        }
        tmpl.engine = engine;
        if (null != caller) {
            tmpl._caller = (TextBuilder)((Object)caller);
        }
        if (null != this._out) {
            tmpl._out = new StringBuilder();
        }
        return tmpl;
    }

    protected void internalInit() {
        this.loadExtendingArgs();
        this.init();
    }

    protected void loadExtendingArgs() {
    }

    @Override
    public void init() {
    }

    @Override
    public final String render() {
        try {
            this.engine.preprocess(this);
            return this.internalRender();
        }
        catch (ClassReloadException e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Cannot hotswap class, try to restart engine...", new Object[0]);
            }
            this.engine.restart(e);
            return this.render();
        }
        catch (ClassCastException e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("ClassCastException found, force refresh template and try again...", new Object[0]);
            }
            TemplateClass tc = this.engine.classes.getByClassName(this.getClass().getName());
            tc.refresh(true);
            ITemplate t = tc.asTemplate();
            return t.render();
        }
    }

    protected void internalBuild() {
        this.internalInit();
        if (this.engine.isProdMode()) {
            this.build();
        } else {
            RuntimeException theRE = null;
            try {
                this.build();
            }
            catch (RythmException e) {
                theRE = e;
                throw e;
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String msg = null;
                for (StackTraceElement se : stackTrace) {
                    TemplateClass tc;
                    String cName = se.getClassName();
                    if (!cName.contains("__R_T_C__")) continue;
                    if (cName.indexOf("$") != -1) {
                        cName = cName.substring(0, cName.lastIndexOf("$"));
                    }
                    if (null == (tc = this.engine.classes.getByClassName(cName))) continue;
                    if (null == msg && S.isEmpty(msg = e.getMessage())) {
                        msg = "caused by " + e.getClass().getName();
                    }
                    RythmException re = new RythmException(e, tc, se.getLineNumber(), -1, msg);
                    if (re.templatelineNumber != -1) {
                        StackTraceElement[] newStack = new StackTraceElement[stackTrace.length + 1];
                        newStack[0] = new StackTraceElement(tc.name(), "", tc.getKey(), re.templatelineNumber);
                        System.arraycopy(stackTrace, 0, newStack, 1, stackTrace.length);
                        re.setStackTrace(newStack);
                    }
                    theRE = re;
                    throw re;
                }
                theRE = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                throw theRE;
            }
            finally {
                try {
                    this.engine.restart(theRE);
                }
                catch (RuntimeException e) {}
            }
        }
    }

    protected String internalRender() {
        this.internalBuild();
        if (null != this.__parent) {
            this.__parent.setRenderBody(this.toString());
            this.__parent.addAllRenderSections(this.renderSections);
            this.__parent.addAllRenderProperties(this.renderProperties);
            return this.__parent.render();
        }
        return this.toString();
    }

    @Override
    public TextBuilder build() {
        return this;
    }

    @Override
    public void setRenderArgs(Map<String, Object> args) {
        this._properties.putAll(args);
    }

    protected void setRenderArgs(ITag.ParameterList params) {
        for (int i = 0; i < params.size(); ++i) {
            ITag.Parameter param = params.get(i);
            if (null != param.name) {
                this.setRenderArg(param.name, param.value);
                continue;
            }
            this.setRenderArg(i, param.value);
        }
    }

    @Override
    public void setRenderArgs(Object ... args) {
    }

    @Override
    public void setRenderArg(String name, Object arg) {
        this._properties.put(name, arg);
    }

    protected final void _set(String name, Object arg) {
        this.setRenderArg(name, arg);
    }

    protected final TemplateBase caller() {
        return null == this._caller ? null : (TemplateBase)this._caller;
    }

    @Override
    public Object getRenderArg(String name) {
        Object val = this._properties.get(name);
        return null != val ? val : (null != this._caller ? this.caller().getRenderArg(name) : null);
    }

    protected final Object _get(String name) {
        return this.getRenderArg(name);
    }

    protected final <T> T _getAs(String name, Class<T> c) {
        Object o = this.getRenderArg(name);
        if (null == o) {
            return null;
        }
        return (T)o;
    }

    protected final Object _getRenderProperty(String name, Object def) {
        Object o = this.renderProperties.get(name);
        return null == o ? def : o;
    }

    protected final Object _getRenderProperty(String name) {
        return this._getRenderProperty(name, null);
    }

    protected final <T> T _getRenderPropertyAs(String name, T def) {
        Object o = this._getRenderProperty(name, def);
        return (T)(null == o ? def : o);
    }

    protected final void _setRenderProperty(String name, Object val) {
        this.renderProperties.put(name, val);
    }

    @Override
    public Map<String, Object> getRenderArgs() {
        return new HashMap<String, Object>(this._properties);
    }

    @Override
    public void setRenderArg(int position, Object arg) {
    }

    @Override
    public StringBuilder getOut() {
        return this.out();
    }

    @Override
    public void setOut(StringBuilder out) {
        if (null != this._caller) {
            ((ITemplate)((Object)this._caller)).setOut(out);
        } else {
            this._out = out;
        }
    }

    protected static void _debug(String msg, Object ... args) {
        _logger.debug(msg, args);
    }

    protected static void _info(String msg, Object ... args) {
        _logger.info(msg, args);
    }

    protected static void _error(String msg, Object ... args) {
        _logger.error(msg, args);
    }

    protected static void _error(Throwable t, String msg, Object ... args) {
        _logger.error(t, msg, args);
    }
}

