/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.play.RythmPlugin;
import com.greenlaw110.rythm.play.RythmTemplateLoader;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.ITemplateResourceLoader;
import com.greenlaw110.rythm.resource.TemplateResourceBase;
import com.greenlaw110.rythm.runtime.ITag;
import java.io.InputStream;
import play.Play;
import play.libs.IO;
import play.vfs.VirtualFile;

public class VirtualFileTemplateResourceLoader
implements ITemplateResourceLoader {
    public static VirtualFileTemplateResourceLoader instance = new VirtualFileTemplateResourceLoader();

    public static boolean isValid(VirtualFile file) {
        return null != file && file.exists() && file.getRealFile().canRead();
    }

    private VirtualFile loadFromPath_(String path) {
        VirtualFile vf = null;
        if (path.indexOf("module:") != -1) {
            vf = VirtualFile.fromRelativePath((String)path);
        } else {
            vf = Play.getVirtualFile((String)path);
            if (!VirtualFileTemplateResourceLoader.isValid(vf)) {
                String path0;
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (!path.startsWith(RythmPlugin.templateRoot2)) {
                    path0 = RythmPlugin.templateRoot2 + path;
                    vf = Play.getVirtualFile((String)path0);
                }
                if (!VirtualFileTemplateResourceLoader.isValid(vf) && !path.startsWith(RythmPlugin.templateRoot)) {
                    path0 = RythmPlugin.templateRoot + path;
                    vf = Play.getVirtualFile((String)path0);
                }
                if (!VirtualFileTemplateResourceLoader.isValid(vf) && !path.startsWith(RythmPlugin.tagRoot)) {
                    path0 = RythmPlugin.tagRoot + path;
                    vf = Play.getVirtualFile((String)path0);
                }
            }
        }
        return vf;
    }

    public ITemplateResource load(String path) {
        VirtualFile vf = this.loadFromPath_(path);
        if (!VirtualFileTemplateResourceLoader.isValid(vf) && path.indexOf("module:") == -1) {
            path = path.replace(".", "/");
            int pos = path.lastIndexOf("/");
            String path0 = path;
            path = path0.substring(0, pos) + "." + path0.substring(pos + 1);
            vf = this.loadFromPath_(path);
        }
        if (!VirtualFileTemplateResourceLoader.isValid(vf)) {
            return null;
        }
        return this.load(vf, false);
    }

    private ITemplateResource load(VirtualFile file, boolean checkBWList) {
        String path = file.relativePath();
        if (path.contains(".svn")) {
            return null;
        }
        if (checkBWList && (RythmPlugin.defaultEngine == RythmPlugin.EngineType.system ? !RythmTemplateLoader.whiteListed(path) : RythmTemplateLoader.blackListed(path))) {
            return null;
        }
        return new VirtualFileTemplateResource(file);
    }

    public ITemplateResource load(VirtualFile file) {
        return this.load(file, true);
    }

    public TemplateClass tryLoadTag(String tagName) {
        RythmEngine engine = RythmPlugin.engine;
        if (engine.tags.containsKey(tagName)) {
            return null;
        }
        String origName = tagName;
        tagName = tagName.replace('.', '/');
        String[] suffixes = new String[]{".html", ".json", ".tag"};
        String[] roots = new String[]{RythmPlugin.templateRoot2, RythmPlugin.tagRoot, RythmPlugin.templateRoot};
        String tagName0 = tagName;
        for (String root : roots) {
            tagName = root + "/" + tagName0;
            VirtualFile tagFile = null;
            for (String suffix : suffixes) {
                String name = tagName + suffix;
                tagFile = Play.getVirtualFile((String)name);
                if (null == tagFile || !tagFile.getRealFile().canRead()) continue;
                try {
                    VirtualFileTemplateResource tr = new VirtualFileTemplateResource(tagFile);
                    TemplateClass tc = engine.classes.getByTemplate(tr.getKey());
                    if (null == tc) {
                        tc = new TemplateClass((ITemplateResource)tr, engine);
                    }
                    try {
                        ITag tag = (ITag)tc.asTemplate();
                        if (null == tag) continue;
                        engine.registerTag(origName, tag);
                        return tc;
                    }
                    catch (Exception e) {
                        RythmPlugin.error(e, "error trying load tag[%s]", origName);
                        return tc;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof RythmException)) continue;
                    throw (RythmException)((Object)e);
                }
            }
        }
        return null;
    }

    public static class VirtualFileTemplateResource
    extends TemplateResourceBase {
        private static final long serialVersionUID = -4307922939957393745L;
        private String tagName;
        private VirtualFile file;

        VirtualFileTemplateResource(VirtualFile file) {
            this.file = file;
            String tagRoot = RythmPlugin.tagRoot;
            if (!tagRoot.startsWith("/")) {
                tagRoot = '/' + tagRoot;
            }
            String filePath = file.relativePath();
            if ((filePath = filePath.replaceFirst("\\{.*\\}", "")).startsWith(tagRoot)) {
                String tagName = filePath.substring(tagRoot.length() + 1);
                while (tagName.startsWith("/") || tagName.startsWith("\\")) {
                    tagName = tagName.substring(1);
                }
                tagName = tagName.replace('\\', '.');
                tagName = tagName.replace('/', '.');
                int dot = tagName.lastIndexOf(".");
                this.tagName = tagName.substring(0, dot);
            }
        }

        protected long defCheckInterval() {
            return 100L;
        }

        protected long lastModified() {
            return this.file.lastModified();
        }

        protected String reload() {
            return IO.readContentAsString((InputStream)this.file.inputstream());
        }

        public String getKey() {
            String path = this.file.relativePath();
            return path.replaceFirst("\\{.*?\\}", "");
        }

        public boolean isValid() {
            return VirtualFileTemplateResourceLoader.isValid(this.file);
        }

        public String getSuggestedClassName() {
            return VirtualFileTemplateResource.path2CN((String)this.file.relativePath().replaceFirst("\\{.*\\}", ""));
        }

        public String tagName() {
            return this.tagName;
        }
    }
}

