/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.compiler;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.compiler.TemplateCompiler;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.resource.ITemplateResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateClassManager {
    protected final ILogger logger = Logger.get(TemplateClassManager.class);
    public RythmEngine engine = null;
    TemplateCompiler compiler = new TemplateCompiler(this);
    public Map<String, TemplateClass> clsNameIdx = new HashMap<String, TemplateClass>();
    public Map<String, TemplateClass> tmplIdx = new HashMap<String, TemplateClass>();

    public TemplateClassManager(RythmEngine engine) {
        if (null == engine) {
            throw new NullPointerException();
        }
        this.engine = engine;
    }

    public void clear() {
        this.clsNameIdx = new HashMap<String, TemplateClass>();
        this.tmplIdx = new HashMap<String, TemplateClass>();
    }

    public List<TemplateClass> all() {
        return new ArrayList<TemplateClass>(this.clsNameIdx.values());
    }

    public TemplateClass getByClassName(String name) {
        TemplateClass tc = this.clsNameIdx.get(name);
        this.checkUpdate(tc);
        return tc;
    }

    public TemplateClass getByTemplate(String name) {
        TemplateClass tc = this.tmplIdx.get(name);
        if (null == tc) {
            ITemplateResource r = this.engine.resourceManager.getFileResource(name);
            if (null == r) {
                return null;
            }
            tc = this.tmplIdx.get(r.getKey());
        }
        this.checkUpdate(tc);
        return tc;
    }

    private void checkUpdate(TemplateClass tc) {
        if (null == tc) {
            return;
        }
        if (null != tc && this.engine.refreshOnRender()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("checkUpdate for template: %s", tc.getKey());
            }
            try {
                this.engine.classLoader.detectChange(tc);
            }
            catch (ClassReloadException e) {
                this.engine.restart(e);
            }
        }
    }

    List<TemplateClass> getEmbeddedClasses(String name) {
        ArrayList<TemplateClass> l = new ArrayList<TemplateClass>();
        for (String cn : this.clsNameIdx.keySet()) {
            if (!cn.startsWith(name + "$")) continue;
            l.add(this.clsNameIdx.get(cn));
        }
        return l;
    }

    public void add(TemplateClass templateClass) {
        this.clsNameIdx.put(templateClass.name0(), templateClass);
        this.clsNameIdx.put(templateClass.name(), templateClass);
        if (!templateClass.isInner()) {
            this.tmplIdx.put(templateClass.templateResource.getKey(), templateClass);
        }
    }

    public void remove(TemplateClass templateClass) {
        if (null == templateClass) {
            return;
        }
        if (templateClass.isInner()) {
            this.clsNameIdx.remove(templateClass.name());
            return;
        }
        this.clsNameIdx.remove(templateClass.name());
        String name0 = templateClass.name0();
        this.clsNameIdx.remove(name0);
        ArrayList<String> embedded = new ArrayList<String>();
        for (String cn : this.clsNameIdx.keySet()) {
            if (!cn.matches(name0 + "v[0-9]+\\$.*")) continue;
            embedded.add(cn);
        }
        for (String cn : embedded) {
            this.clsNameIdx.remove(cn);
        }
        if (null != templateClass && null != templateClass.templateResource) {
            this.tmplIdx.remove(templateClass.getKey());
        }
    }

    public void remove(String name) {
        TemplateClass templateClass = this.clsNameIdx.get(name);
        this.remove(templateClass);
    }

    public boolean hasClass(String name) {
        return this.clsNameIdx.containsKey(name);
    }

    public String toString() {
        return this.clsNameIdx.toString();
    }
}

