/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.dialect;

import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.dialect.SimpleRythm;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.spi.IParserFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DialectManager {
    IDialect def = null;
    static ThreadLocal<Stack<IDialect>> threadLocal = new ThreadLocal();
    static IDialect[] dialects;
    static Map<String, IDialect> dialectIdMap;
    private Map<IDialect, List<IParserFactory>> externalParsers = new HashMap<IDialect, List<IParserFactory>>();

    public DialectManager() {
        this.def = new Rythm();
    }

    public IDialect get() {
        return threadLocal.get().peek();
    }

    public void push(IDialect dialect) {
        threadLocal.get().push(dialect);
    }

    public IDialect pop() {
        return threadLocal.get().pop();
    }

    public IDialect get(String id) {
        if (null == id || "rythm".equalsIgnoreCase(id)) {
            return this.def;
        }
        return null;
    }

    public void beginParse(IContext ctx) {
        IDialect d;
        List<IParserFactory> l;
        String template = ctx.getRemain();
        for (IDialect d2 : dialects) {
            if (!d2.isMyTemplate(template)) continue;
            this.push(d2);
            d2.begin(ctx);
            break;
        }
        if (null != (l = this.externalParsers.get(d = this.get()))) {
            for (IParserFactory pf : l) {
                d.registerParserFactory(pf);
            }
        }
    }

    public void endParse(IContext ctx) {
        IDialect d = this.pop();
        d.end(ctx);
    }

    public void registerExternalParsers(String dialect, IParserFactory ... factories) {
        IDialect d;
        if (null == dialect) {
            dialect = "rythm";
        }
        if (null == (d = dialectIdMap.get(dialect))) {
            throw new IllegalArgumentException("dialect not found: " + dialect);
        }
        this.externalParsers.put(d, Arrays.asList(factories));
    }

    static {
        Stack<Rythm> stack = new Stack<Rythm>();
        stack.push(new Rythm());
        threadLocal.set(stack);
        dialects = new IDialect[]{new SimpleRythm(), new Rythm()};
        dialectIdMap = new HashMap<String, IDialect>();
        for (IDialect dialect : dialects) {
            dialectIdMap.put(dialect.id(), dialect);
        }
    }
}

