/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.exception.CompileException;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.play.RythmPlugin;
import com.greenlaw110.rythm.play.RythmTemplate;
import com.greenlaw110.rythm.play.TemplateParseException;
import com.greenlaw110.rythm.play.VirtualFileTemplateResourceLoader;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.runtime.ITag;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.exceptions.TemplateCompilationException;
import play.exceptions.UnexpectedException;
import play.templates.Template;
import play.vfs.VirtualFile;

public class RythmTemplateLoader {
    private static VirtualFileTemplateResourceLoader resourceLoader = VirtualFileTemplateResourceLoader.instance;
    static ConcurrentMap<String, RythmTemplate> cache = new ConcurrentHashMap<String, RythmTemplate>();
    private static Object lock_ = new Object();

    static Method getActionMethod(String path) {
        Method[] methods;
        String templateRoot = RythmPlugin.templateRoot;
        int pos = path.indexOf(templateRoot);
        if (-1 != pos) {
            path = path.substring(pos + templateRoot.length());
        }
        while (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        pos = path.lastIndexOf(46);
        if (-1 != pos) {
            path = path.substring(0, pos);
        }
        if (-1 == (pos = (path = path.replace('/', '.')).lastIndexOf(46))) {
            return null;
        }
        String cName = "controllers." + path.substring(0, pos);
        String mName = path.substring(pos + 1);
        ApplicationClasses.ApplicationClass ac = Play.classes.getApplicationClass(cName);
        if (null == ac) {
            return null;
        }
        Class c = ac.javaClass;
        for (Method m : methods = c.getMethods()) {
            int flag = m.getModifiers();
            if (Modifier.isAbstract(flag) || !Modifier.isStatic(flag) || !Void.TYPE.equals(m.getReturnType()) || !mName.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        return null;
    }

    private static void scanTagFolder(VirtualFile root) {
        class FileTraversal {
            FileTraversal() {
            }

            public final void traverse(VirtualFile f) {
                if (f.isDirectory()) {
                    if (".svn".equals(f.getName())) {
                        return;
                    }
                    List children = f.list();
                    for (VirtualFile child : children) {
                        this.traverse(child);
                    }
                    return;
                }
                this.onFile(f);
            }

            public void onFile(VirtualFile f) {
                try {
                    ITag tag;
                    VirtualFileTemplateResourceLoader.VirtualFileTemplateResource resource = new VirtualFileTemplateResourceLoader.VirtualFileTemplateResource(f);
                    TemplateClass templateClass = RythmPlugin.engine.classes.getByTemplate(resource.getKey());
                    if (null == templateClass) {
                        templateClass = new TemplateClass((ITemplateResource)resource, RythmPlugin.engine);
                    }
                    if (null != (tag = (ITag)templateClass.asTemplate())) {
                        RythmPlugin.engine.registerTag(tag);
                    }
                }
                catch (RythmException e) {
                    RythmTemplate.TemplateInfo t = RythmTemplate.handleRythmException(e);
                    if (e instanceof ParseException) {
                        throw new TemplateParseException(t, (ParseException)((Object)e));
                    }
                    if (e instanceof CompileException) {
                        throw new TemplateCompilationException((Template)t, Integer.valueOf(t.lineNo), e.getMessage());
                    }
                    throw new UnexpectedException("Don't know why I am here");
                }
                catch (Exception e) {
                    Logger.warn((Throwable)e, (String)"error loading tag: %s", (Object[])new Object[]{f.relativePath()});
                }
            }
        }
        new FileTraversal().traverse(root);
    }

    static void scanTagFolder() {
    }

    public static Template loadTemplate(VirtualFile file) {
        String path;
        if (Logger.isTraceEnabled()) {
            RythmPlugin.trace("about to load template: %s", file);
        }
        if (!(path = file.relativePath()).contains("app/rythm")) {
            return null;
        }
        if (path.indexOf("conf/routes") != -1) {
            return null;
        }
        if (path.endsWith(".xls") || path.endsWith(".xlsx") || path.endsWith(".pdf")) {
            return null;
        }
        RythmTemplate rt = (RythmTemplate)((Object)cache.get(path));
        if (null != rt) {
            if (Logger.isTraceEnabled()) {
                RythmPlugin.trace("template[%s] loaded from cache. About to refresh it", file);
            }
            if (RythmPlugin.engine.mode.isDev()) {
                rt.refresh();
            }
            if (Logger.isTraceEnabled()) {
                RythmPlugin.trace("template[%s] refreshed", file);
            }
            return rt.isValid() ? rt : null;
        }
        rt = (RythmTemplate)((Object)cache.get(path));
        if (null != rt) {
            rt.refresh();
            return rt.isValid() ? rt : null;
        }
        ITemplateResource resource = resourceLoader.load(file);
        if (null == resource || !resource.isValid()) {
            return null;
        }
        RythmTemplate tc = new RythmTemplate(resource);
        if (Logger.isTraceEnabled()) {
            RythmPlugin.trace("about to refresh template: %s", file);
        }
        if (Play.mode.isDev()) {
            tc.refresh(true);
        } else {
            tc.refresh();
        }
        if (tc.isValid()) {
            cache.put(file.relativePath(), tc);
        } else {
            tc = null;
        }
        if (Logger.isTraceEnabled()) {
            RythmPlugin.trace("template[%s] refreshed", file);
        }
        return tc;
    }

    static void clear() {
        cache.clear();
    }

    public static void main(String[] args) {
        String path = "route";
        int dot = path.lastIndexOf(46);
        path = -1 == dot ? path + ".rythm" : path.substring(0, dot) + ".rythm" + path.substring(dot);
        System.out.println(path);
    }
}

