/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.resource;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.TemplateResourceBase;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.utils.IO;
import java.io.File;

public class FileTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private ILogger logger = Logger.get(FileTemplateResource.class);
    private File file;
    private String key;
    private String tagName;

    @Override
    protected long defCheckInterval() {
        return 5000L;
    }

    public FileTemplateResource(String path) {
        this(path, null);
    }

    public FileTemplateResource(String path, RythmEngine engine) {
        super(engine);
        File home = this.engine().templateHome;
        File tagHome = this.engine().tagHome;
        File f = null;
        if (null != home) {
            f = new File(home, path);
        }
        if (!(null != f && f.canRead() || null == tagHome)) {
            f = new File(tagHome, path);
        }
        if (null == f || !f.canRead()) {
            f = new File(path);
        }
        this.file = f;
        this.key = path;
        if (null != tagHome && this.isValid()) {
            String tagPath = tagHome.getAbsolutePath();
            String filePath = f.getAbsolutePath();
            if (filePath.startsWith(tagPath)) {
                this.tagName = FileTemplateResource.retrieveTagName(tagHome, f);
            }
        }
    }

    public FileTemplateResource(File templateFile) {
        this(templateFile, null);
    }

    public FileTemplateResource(File templateFile, RythmEngine engine) {
        super(engine);
        File home = this.engine().templateHome;
        File tagHome = this.engine().tagHome;
        this.file = templateFile;
        this.key = this.file.getPath();
        if (null != tagHome && this.isValid()) {
            String tagPath = tagHome.getAbsolutePath();
            String filePath = this.file.getAbsolutePath();
            if (filePath.startsWith(tagPath)) {
                this.tagName = FileTemplateResource.retrieveTagName(tagHome, this.file);
            }
        }
    }

    private static String retrieveTagName(File tagHome, File tagFile) {
        String tagPath = tagHome.getAbsolutePath();
        String filePath = tagFile.getAbsolutePath();
        String tagName = null;
        if (filePath.startsWith(tagPath)) {
            tagName = filePath.substring(tagPath.length());
            while (tagName.startsWith("/") || tagName.startsWith("\\")) {
                tagName = tagName.substring(1);
            }
            tagName = tagName.replace('\\', '.');
            tagName = tagName.replace('/', '.');
            int dot = tagName.lastIndexOf(".");
            tagName = tagName.substring(0, dot);
        }
        return tagName;
    }

    public static void main(String[] args) {
        File tagHome = new File("W:\\_lgl\\greenscript-1.2\\java\\play\\app\\views\\tags\\");
        File tagFile = new File("W:\\_lgl\\greenscript-1.2\\java\\play\\app\\views\\tags\\greenscript\\css.html");
        System.out.println(FileTemplateResource.retrieveTagName(tagHome, tagFile));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    protected Long userCheckInterval() {
        return this.engine().configuration.getAsLong("rythm.resource.file.interval", null);
    }

    @Override
    public boolean isValid() {
        return null != this.file && this.file.canRead();
    }

    @Override
    protected String reload() {
        return IO.readContentAsString(this.file);
    }

    @Override
    public String getSuggestedClassName() {
        return FileTemplateResource.path2CN(this.file.getPath());
    }

    @Override
    public String tagName() {
        return this.tagName;
    }

    public static String getFullTagName(TemplateClass tc, RythmEngine engine) {
        int pos;
        String key;
        if (null == engine) {
            engine = Rythm.engine;
        }
        if ((key = tc.getKey()).startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (null != engine.templateHome && key.startsWith(engine.templateHome.getPath())) {
            key = key.replace(engine.templateHome.getPath(), "");
        }
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (-1 != (pos = key.lastIndexOf("."))) {
            key = key.substring(0, pos);
        }
        return key.replace('/', '.').replace('\\', '.');
    }

    public static TemplateClass tryLoadTag(String tagName, RythmEngine engine) {
        if (null == engine) {
            engine = Rythm.engine;
        }
        if (engine.tags.containsKey(tagName)) {
            return null;
        }
        tagName = tagName.replace('.', '/');
        String[] suffixes = new String[]{".html", ".json", ".tag"};
        File tagFile = null;
        File[] roots = new File[]{engine.tagHome, engine.templateHome};
        for (String suffix : suffixes) {
            String name = tagName + suffix;
            for (File root : roots) {
                if (null == root || !(tagFile = new File(root, name)).canRead()) continue;
                try {
                    FileTemplateResource tr = new FileTemplateResource(tagFile, engine);
                    TemplateClass tc = engine.classes.getByTemplate(tr.getKey());
                    if (null == tc) {
                        tc = new TemplateClass(tr, engine);
                    }
                    try {
                        ITag tag = (ITag)tc.asTemplate();
                        if (null == tag) continue;
                        engine.registerTag(tagName, tag);
                        return tc;
                    }
                    catch (Exception e) {
                        return tc;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

