/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.compiler;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.CompileException;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClassManager;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.StringTemplateResource;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.spi.ITemplateClassEnhancer;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.utils.S;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateClass {
    private static AtomicLong nextVersion = new AtomicLong();
    private static final ILogger logger = Logger.get(TemplateClass.class);
    private TemplateClass root;
    private boolean inner = false;
    private RythmEngine engine = null;
    private String name;
    private long version;
    public TemplateClass extendedTemplateClass;
    private Set<TemplateClass> includedTemplateClasses = new HashSet<TemplateClass>();
    public String includeTemplateClassNames = null;
    private static final String NO_INCLUDE_CLASS = "NO_INCLUDE_CLASS";
    public ITemplateResource templateResource;
    public String javaSource;
    public byte[] javaByteCode;
    public byte[] enhancedByteCode;
    public Set<String> importPaths;
    public Class<ITemplate> javaClass;
    public Package javaPackage;
    boolean compiled;
    public int sigChecksum;
    public boolean isValid = true;
    public CodeBuilder codeBuilder;
    public boolean simpleTemplate;
    public TemplateBase templateInstance;
    private transient IDialect dialect;
    private static final ITemplate NULL_TEMPLATE = new TemplateBase(){

        @Override
        public ITemplate cloneMe(RythmEngine engine, ITemplate caller) {
            return null;
        }
    };
    private boolean refreshing = false;
    private boolean compiling = false;
    private Object refreshLock = new Object();
    public static final String CN_SUFFIX = "__R_T_C__";
    private boolean enhancing = false;
    private transient List<TemplateClass> embeddedClasses = new ArrayList<TemplateClass>();

    public TemplateClass root() {
        return this.root;
    }

    private TemplateClass() {
    }

    public static TemplateClass createInnerClass(String className, byte[] byteCode, TemplateClass parent) {
        TemplateClass tc = new TemplateClass();
        tc.name = className;
        tc.javaByteCode = byteCode;
        tc.inner = true;
        tc.root = parent.root();
        tc.version = parent.version();
        return tc;
    }

    public boolean isInner() {
        return this.inner;
    }

    private RythmEngine engine() {
        return null == this.engine ? Rythm.engine() : this.engine;
    }

    public String name0() {
        return this.name;
    }

    public String name() {
        RythmEngine e = this.engine();
        String n = !e.reloadByIncClassVersion() || this.isInner() ? this.name : this.name + "v" + this.version;
        return n;
    }

    public long version() {
        return this.root().version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public void addIncludeTemplateClass(TemplateClass tc) {
        this.includedTemplateClasses.add(tc);
    }

    public String refreshIncludeTemplateClassNames() {
        if (this.includedTemplateClasses.size() == 0) {
            this.includeTemplateClassNames = NO_INCLUDE_CLASS;
            return NO_INCLUDE_CLASS;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TemplateClass tc : this.includedTemplateClasses) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.engine().resourceManager.getFullTagName(tc));
        }
        this.includeTemplateClassNames = sb.toString();
        return sb.toString();
    }

    public String tagName() {
        return null != this.templateResource ? this.templateResource.tagName() : null;
    }

    public String getTemplateSource() {
        return this.getTemplateSource(false);
    }

    public String getTemplateSource(boolean includeRoot) {
        if (null != this.templateResource) {
            return this.templateResource.asTemplateContent();
        }
        if (!includeRoot) {
            return "";
        }
        TemplateClass parent = this.root;
        while (null != parent && parent.isInner()) {
            parent = parent.root;
        }
        return null == parent ? "" : parent.getTemplateSource();
    }

    public boolean isStringTemplate() {
        return this.templateResource instanceof StringTemplateResource;
    }

    private TemplateClass(RythmEngine engine) {
        this.engine = null == engine ? null : (engine.isSingleton() ? null : engine);
    }

    public TemplateClass(File file, RythmEngine engine) {
        this(engine.resourceManager.get(file), engine);
    }

    public TemplateClass(String template, RythmEngine engine) {
        this(engine.resourceManager.get(template), engine);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine) {
        this(resource, engine, false);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, IDialect dialect) {
        this(resource, engine, false, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        this.templateResource = resource;
        if (resource instanceof StringTemplateResource) {
            this.simpleTemplate = true;
        }
        if (!noRefresh) {
            this.refresh();
        }
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh, IDialect dialect) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        this.templateResource = resource;
        if (resource instanceof StringTemplateResource) {
            this.simpleTemplate = true;
        }
        this.dialect = dialect;
        if (!noRefresh) {
            this.refresh();
        }
    }

    public String getKey() {
        return null == this.templateResource ? this.name() : this.templateResource.getKey();
    }

    private Class<?> getJavaClass() throws Exception {
        Class<?> c = this.engine().classLoader.loadClass(this.name(), true);
        if (null == this.javaClass) {
            this.javaClass = c;
        }
        return c;
    }

    private ITemplate templateInstance_() {
        Class<?> c;
        Class<?> pc;
        if (!this.isValid) {
            return NULL_TEMPLATE;
        }
        if (null == this.templateInstance) {
            try {
                if (Logger.isTraceEnabled()) {
                    logger.trace("About to new template instance", new Object[0]);
                }
                Class<?> clz = this.getJavaClass();
                if (Logger.isTraceEnabled()) {
                    logger.trace("template java class loaded", new Object[0]);
                }
                this.templateInstance = (TemplateBase)clz.newInstance();
                if (Logger.isTraceEnabled()) {
                    logger.trace("template instance generated", new Object[0]);
                }
            }
            catch (RythmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error load template instance for " + this.getKey(), e);
            }
        }
        if (!this.engine().isProdMode() && null != (pc = (c = this.templateInstance.getClass()).getSuperclass()) && !Modifier.isAbstract(pc.getModifiers())) {
            this.engine().classes.getByClassName(pc.getName());
        }
        this.templateInstance.setTemplateClass(this);
        return this.templateInstance;
    }

    public ITemplate asTemplate() {
        if (null == this.name || this.engine().mode.isDev()) {
            this.refresh();
        }
        return this.templateInstance_().cloneMe(this.engine(), null);
    }

    public ITemplate asTemplate(ITemplate caller) {
        return this.templateInstance_().cloneMe(this.engine(), caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshing() {
        Object object = this.refreshLock;
        synchronized (object) {
            return this.refreshing || this.compiling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshing(boolean b) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.refreshing = b;
        }
    }

    private void addVersion() {
        RythmEngine e = this.engine();
        if (!e.reloadByIncClassVersion()) {
            return;
        }
        TemplateClassManager tcc = this.engine().classes;
        tcc.clsNameIdx.remove(this.name());
        this.version = nextVersion.getAndIncrement();
        tcc.clsNameIdx.put(this.name(), this);
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public void buildSourceCode() {
        long start = System.currentTimeMillis();
        this.addVersion();
        this.importPaths = new HashSet<String>();
        if (null != this.codeBuilder) {
            this.codeBuilder.clear();
        }
        this.codeBuilder = new CodeBuilder(this.templateResource.asTemplateContent(), this.name(), this.tagName(), this, this.engine, this.dialect);
        this.codeBuilder.build();
        this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
        this.javaSource = this.codeBuilder.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(boolean forceRefresh) {
        if (this.refreshing()) {
            return false;
        }
        if (this.inner) {
            return false;
        }
        try {
            boolean refresh;
            RythmEngine e = this.engine();
            this.refreshing(true);
            if (!this.templateResource.isValid()) {
                this.isValid = false;
                this.engine().classes.remove(this);
                boolean bl = false;
                return bl;
            }
            if (null == this.name) {
                this.root = this;
                this.name = this.templateResource.getSuggestedClassName() + CN_SUFFIX;
                if (e.reloadByIncClassVersion()) {
                    this.version = nextVersion.getAndIncrement();
                }
                this.engine().classes.add(this);
            }
            if (null == this.javaSource) {
                Pattern p;
                Matcher m;
                this.engine().classCache.loadTemplateClass(this);
                if (null != this.javaSource && (m = (p = Pattern.compile(".*extends\\s+([a-zA-Z0-9_]+)\\s*\\{\\s*\\/\\/<extended_resource_key\\>(.*)\\<\\/extended_resource_key\\>.*", 32)).matcher(this.javaSource)).matches()) {
                    String extended = m.group(1);
                    TemplateClassManager tcm = this.engine().classes;
                    this.extendedTemplateClass = tcm.getByClassName(extended);
                    if (null == this.extendedTemplateClass) {
                        String extendedResourceKey = m.group(2);
                        this.extendedTemplateClass = tcm.getByTemplate(extendedResourceKey);
                        if (null == this.extendedTemplateClass) {
                            this.extendedTemplateClass = new TemplateClass(extendedResourceKey, this.engine());
                            this.extendedTemplateClass.refresh();
                        }
                    }
                    this.engine().addExtendRelationship(this.extendedTemplateClass, this);
                }
            }
            boolean extendedTemplateChanged = false;
            if (this.extendedTemplateClass != null) {
                extendedTemplateChanged = this.extendedTemplateClass.refresh(forceRefresh);
            }
            boolean includedTemplateChanged = false;
            if (this.includedTemplateClasses.size() == 0 && !S.isEmpty(this.includeTemplateClassNames) && !NO_INCLUDE_CLASS.equals(this.includeTemplateClassNames)) {
                for (String tcName : this.includeTemplateClassNames.split(",")) {
                    if (S.isEmpty(tcName)) continue;
                    tcName = tcName.trim();
                    String fullName = this.engine().testTag(tcName, this);
                    if (null == fullName) {
                        logger.warn("Unable to load included template class from name: %s", tcName);
                        continue;
                    }
                    TemplateClass tc = this.engine().getTemplateClassFromTagName(fullName);
                    if (null == tc) {
                        logger.warn("Unable to load included template class from name: %s", tcName);
                        continue;
                    }
                    this.includedTemplateClasses.add(tc);
                }
            }
            for (TemplateClass tc : this.includedTemplateClasses) {
                if (!tc.refresh(forceRefresh)) continue;
                includedTemplateChanged = true;
                break;
            }
            if (extendedTemplateChanged && this.engine().reloadByRestart()) {
                this.reset();
                this.compiled = false;
                this.engine().restart(new ClassReloadException("extended class changed"));
                this.refreshing(false);
                this.refresh(forceRefresh);
                boolean i$ = true;
                return i$;
            }
            boolean bl = refresh = this.templateResource.refresh() || forceRefresh || null == this.javaSource || includedTemplateChanged || extendedTemplateChanged;
            if (!refresh) {
                boolean bl2 = false;
                return bl2;
            }
            this.reset();
            this.buildSourceCode();
            this.engine().classCache.cacheTemplateClassSource(this);
            if (!this.codeBuilder.isRythmTemplate()) {
                this.isValid = false;
                this.engine().classes.remove(this);
                boolean bl3 = false;
                return bl3;
            }
            this.isValid = true;
            this.compiled = false;
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.refreshing(false);
        }
    }

    public boolean isDefinable() {
        return this.compiled && this.javaClass != null;
    }

    public void reset() {
        this.javaByteCode = null;
        this.enhancedByteCode = null;
        this.javaSource = null;
        this.templateInstance = null;
        for (TemplateClass tc : this.embeddedClasses) {
            tc.reset();
            this.engine().classes.remove(tc);
        }
        this.embeddedClasses.clear();
        this.engine().classCache.deleteCache(this);
        this.engine().invalidate(this);
        if (this.engine().reloadByIncClassVersion()) {
            this.javaClass = null;
        }
    }

    public byte[] compile() {
        if (null != this.javaByteCode) {
            return this.javaByteCode;
        }
        if (null == this.javaSource) {
            throw new IllegalStateException("Cannot find java source when compiling " + this.getKey());
        }
        this.compiling = true;
        long start = System.currentTimeMillis();
        try {
            this.engine().classes.compiler.compile(new String[]{this.name()});
            if (logger.isTraceEnabled()) {
                logger.trace("%sms to compile template: %s", System.currentTimeMillis() - start, this.getKey());
            }
        }
        catch (CompileException.CompilerException e) {
            TemplateClass tc;
            String cn = e.className;
            TemplateClass templateClass = tc = S.isEqual(cn, this.name()) ? this : this.engine().classes.getByClassName(cn);
            if (null == tc) {
                tc = this;
            }
            CompileException ce = new CompileException(tc, e.javaLineNumber, e.message);
            if (this.engine().isProdMode()) {
                logger.error("error compiling java source:\n%s", this.javaSource);
            }
            this.javaSource = null;
            throw ce;
        }
        catch (NullPointerException e) {
            String clazzName = this.name();
            TemplateClass tc = this.engine().classes.getByClassName(clazzName);
            if (this != tc) {
                logger.error("tc is not this", new Object[0]);
            }
            if (!this.equals(tc)) {
                logger.error("tc not match this", new Object[0]);
            }
            logger.error("NPE encountered when compiling template class:" + this.name(), new Object[0]);
            throw e;
        }
        finally {
            this.compiling = false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey());
        }
        return this.javaByteCode;
    }

    public void delayedEnhance(TemplateClass root) {
        this.enhancedByteCode = this.javaByteCode;
        root.embeddedClasses.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] enhance() {
        if (this.enhancing) {
            throw new IllegalStateException("reenter enhance() call");
        }
        this.enhancing = true;
        try {
            byte[] bytes = this.enhancedByteCode;
            if (null == bytes) {
                bytes = this.javaByteCode;
                if (null == bytes) {
                    bytes = this.compile();
                }
                long start = System.currentTimeMillis();
                for (ITemplateClassEnhancer en : this.engine().templateClassEnhancers) {
                    try {
                        bytes = en.enhance(this.name(), bytes);
                    }
                    catch (Exception e) {
                        logger.warn(e, "Error enhancing template class: %s", this.getKey());
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to enhance template class %s", System.currentTimeMillis() - start, this.getKey());
                }
            }
            this.enhancedByteCode = bytes;
            for (TemplateClass embedded : this.embeddedClasses) {
                embedded.enhance();
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            this.enhancing = false;
        }
    }

    public void uncompile() {
        this.javaClass = null;
    }

    public boolean isClass() {
        return !this.name().endsWith("package-info");
    }

    public String getPackage() {
        int dot = this.name().lastIndexOf(46);
        return dot > -1 ? this.name().substring(0, dot) : "";
    }

    public void loadCachedByteCode(byte[] code) {
        this.enhancedByteCode = code;
    }

    public void compiled(byte[] code, boolean noCache) {
        this.javaByteCode = code;
        this.compiled = true;
        this.enhance();
        if (!noCache) {
            this.engine().classCache.cacheTemplateClass(this);
        }
    }

    public void compiled(byte[] code) {
        this.compiled(code, false);
    }

    public String toString() {
        return "(compiled:" + this.compiled + ") " + this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplateClass) {
            TemplateClass that = (TemplateClass)o;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

