/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.dialect;

import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.dialect.SimpleRythm;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.spi.IParserFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DialectManager {
    protected ILogger logger = Logger.get(DialectManager.class);
    IDialect def = null;
    static ThreadLocal<Stack<IDialect>> threadLocal = new ThreadLocal();
    static IDialect[] dialects;
    static Map<String, IDialect> dialectIdMap;
    private Map<IDialect, List<IParserFactory>> externalParsers = new HashMap<IDialect, List<IParserFactory>>();

    public DialectManager() {
        this.def = new Rythm();
    }

    private Stack<IDialect> dialectStack() {
        Stack<IDialect> stack = threadLocal.get();
        if (null == stack) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }

    public IDialect get() {
        Stack<IDialect> stack = this.dialectStack();
        return stack.empty() ? null : stack.peek();
    }

    public void push(IDialect dialect) {
        this.dialectStack().push(dialect);
    }

    public IDialect pop() {
        Stack<IDialect> stack = this.dialectStack();
        return stack.empty() ? null : stack.pop();
    }

    public IDialect get(String id) {
        if (null == id || "rythm".equalsIgnoreCase(id)) {
            return this.def;
        }
        return null;
    }

    public void beginParse(IContext ctx) {
        List<IParserFactory> l;
        IDialect d = ctx.getCodeBuilder().dialect;
        if (null != d) {
            this.push(d);
            d.begin(ctx);
        } else {
            String template = ctx.getRemain();
            for (IDialect d0 : dialects) {
                if (!d0.isMyTemplate(template)) continue;
                this.push(d0);
                d0.begin(ctx);
                d = d0;
                break;
            }
        }
        d = this.get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>> begin Parse::dialect is: %s", d.getClass());
        }
        if (null != (l = this.externalParsers.get(d))) {
            for (IParserFactory pf : l) {
                d.registerParserFactory(pf);
            }
        }
    }

    public void endParse(IContext ctx) {
        IDialect d = this.pop();
        d.end(ctx);
    }

    public void registerExternalParsers(String dialect, IParserFactory ... factories) {
        IDialect d;
        if (null == dialect) {
            dialect = "rythm";
        }
        if (null == (d = dialectIdMap.get(dialect))) {
            throw new IllegalArgumentException("dialect not found: " + dialect);
        }
        this.externalParsers.put(d, Arrays.asList(factories));
    }

    static {
        Stack<Rythm> stack = new Stack<Rythm>();
        stack.push(new Rythm());
        threadLocal.set(stack);
        dialects = new IDialect[]{new SimpleRythm(), new Rythm()};
        dialectIdMap = new HashMap<String, IDialect>();
        for (IDialect dialect : dialects) {
            dialectIdMap.put(dialect.id(), dialect);
        }
    }
}

