/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.spi;

import com.greenlaw110.rythm.ITagInvokeListener;
import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.spi.IExpressionProcessor;
import com.greenlaw110.rythm.spi.IParserFactory;
import com.greenlaw110.rythm.spi.ITemplateExecutionExceptionHandler;
import java.util.ArrayList;
import java.util.List;

public class ExtensionManager {
    private RythmEngine engine;
    private List<ITemplateExecutionExceptionHandler> exceptionHandlers = new ArrayList<ITemplateExecutionExceptionHandler>();
    private List<IExpressionProcessor> expressionProcessors = new ArrayList<IExpressionProcessor>();
    private List<ITagInvokeListener> tagInvokeListeners = new ArrayList<ITagInvokeListener>();

    public ExtensionManager(RythmEngine engine) {
        this.engine = engine;
    }

    RythmEngine engine() {
        return null == this.engine ? Rythm.engine : this.engine;
    }

    public ExtensionManager registerUserDefinedParsers(IParserFactory ... parsers) {
        return this.registerUserDefinedParsers((String)null, parsers);
    }

    public ExtensionManager registerUserDefinedParsers(String dialect, IParserFactory ... parsers) {
        this.engine().getDialectManager().registerExternalParsers(dialect, parsers);
        return this;
    }

    public ExtensionManager registerTemplateExecutionExceptionHandler(ITemplateExecutionExceptionHandler h) {
        if (!this.exceptionHandlers.contains(h)) {
            this.exceptionHandlers.add(h);
        }
        return this;
    }

    public Iterable<ITemplateExecutionExceptionHandler> exceptionHandlers() {
        return this.exceptionHandlers;
    }

    public ExtensionManager registerExpressionProcessor(IExpressionProcessor p) {
        if (!this.expressionProcessors.contains(p)) {
            this.expressionProcessors.add(p);
        }
        return this;
    }

    public Iterable<IExpressionProcessor> expressionProcessors() {
        return this.expressionProcessors;
    }

    public ExtensionManager registerTagInvoeListener(ITagInvokeListener l) {
        if (!this.tagInvokeListeners.contains(l)) {
            this.tagInvokeListeners.add(l);
        }
        return this;
    }

    public Iterable<ITagInvokeListener> tagInvokeListeners() {
        return this.tagInvokeListeners;
    }
}

