/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.dialect.DialectManager;
import com.greenlaw110.rythm.logger.ILoggerFactory;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.spi.ExtensionManager;
import com.greenlaw110.rythm.spi.ITemplateClassEnhancer;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.utils.IRythmListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class Rythm {
    public static RythmEngine engine = null;
    public static final String version = "1.0.0-20120704a";

    public static void init(Properties conf) {
        engine = new RythmEngine(conf);
    }

    public static void init() {
        engine = new RythmEngine();
    }

    private static void checkInit() {
        if (null == engine) {
            Rythm.init();
        }
    }

    public static RythmEngine engine() {
        Rythm.checkInit();
        return engine;
    }

    public static void registerLoggerFactory(ILoggerFactory fact) {
        Logger.registerLoggerFactory(fact);
    }

    public static void registerListener(IRythmListener listener) {
        Rythm.engine().registerListener(listener);
    }

    public static void unregisterListener(IRythmListener listener) {
        Rythm.engine().unregisterListener(listener);
    }

    public static void clearListener() {
        Rythm.engine().clearListener();
    }

    public static void registerTemplateClassEnhancer(ITemplateClassEnhancer enhancer) {
        Rythm.engine().registerTemplateClassEnhancer(enhancer);
    }

    public static void unregisterTemplateClassEnhancer(ITemplateClassEnhancer enhancer) {
        Rythm.engine().unregisterTemplateClassEnhancer(enhancer);
    }

    public static void clearTemplateClassEnhancer() {
        Rythm.engine().clearTemplateClassEnhancer();
    }

    public static boolean registerTag(ITag tag) {
        return Rythm.engine().registerTag(tag);
    }

    public boolean registerTag(String name, ITag tag) {
        return Rythm.engine().registerTag(name, tag);
    }

    public boolean isProdMode() {
        return Rythm.engine().isProdMode();
    }

    public static String render(String template, Object ... args) {
        return Rythm.engine().render(template, args);
    }

    public static String render(File file, Object ... args) {
        return Rythm.engine().render(file, args);
    }

    public static String toString(String template, Object obj) {
        return Rythm.engine().toString(template, obj);
    }

    public static String renderStr(String template, Object ... args) {
        return Rythm.engine().renderString(template, args);
    }

    public static String renderString(String template, Object ... args) {
        return Rythm.engine().renderString(template, args);
    }

    public static String renderIfTemplateExists(String template, Object ... args) {
        return Rythm.engine().renderIfTemplateExists(template, args);
    }

    public static void shutdown() {
        Rythm.engine().shutdown();
    }

    public static void main(String[] args) {
        String template = "@args java.util.List<String> users, String title, String name; @each String u: users @u @ title: @title name: @name ";
        ArrayList<String> l = new ArrayList<String>();
        l.add("green");
        l.add("cherry");
        ITemplate t = engine.getTemplate(template, new Object[0]);
        t.setRenderArg("users", l);
        t.setRenderArg(2, (Object)"Green");
        t.setRenderArg(1, (Object)"Mr.");
        System.out.println(t.render());
    }

    public static void main2(String[] args) {
        String s = "@args java.util.Properties component; <input type='checkbox' @if (Boolean.valueOf(String.valueOf(component.get(\"checked\")))) checked @ >";
        Properties p = new Properties();
        p.put("checked", "true");
        HashMap<String, Properties> m = new HashMap<String, Properties>();
        m.put("component", p);
        System.out.println(Rythm.render(s, m));
    }

    public static void main1(String[] args) {
        int i;
        String template = "@args String who1, String who2; Hello @who1 and @who2!";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("who1", "uni");
        m.put("who2", "world");
        long start = System.currentTimeMillis();
        System.out.println(Rythm.render(template, m));
        System.out.println(String.format("%s ms to render inline template at first time", System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        String r = "";
        for (i = 0; i < 500000; ++i) {
            r = Rythm.render(template, m);
        }
        System.out.println();
        System.out.println(r);
        System.out.println(String.format("%s ms to render for 500000 times", System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        for (i = 0; i < 500000; ++i) {
            r = String.format("Hello %s and %s", "uni", "world");
        }
        System.out.println();
        System.out.println(r);
        System.out.println(String.format("%s ms to string format for 500000 times", System.currentTimeMillis() - start));
    }

    public static DialectManager getDialectManager() {
        return Rythm.engine().getDialectManager();
    }

    public static ExtensionManager getExtensionManager() {
        return Rythm.engine().getExtensionManager();
    }

    public static enum ReloadMethod {
        V_VERSION,
        RESTART;

    }

    public static enum Mode {
        dev,
        prod;


        public boolean isDev() {
            return dev == this;
        }

        public boolean isProd() {
            return prod == this;
        }
    }
}

