/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.dialect;

import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.spi.IKeyword;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.IParserFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DialectBase
implements IDialect {
    private List<IParserFactory> freeParsers = new ArrayList<IParserFactory>();
    private final Map<String, KeywordParserFactory> keywords = new HashMap<String, KeywordParserFactory>();
    private final Map<String, KeywordParserFactory> keywords2 = new HashMap<String, KeywordParserFactory>();

    public DialectBase() {
        this.registerBuildInParsers();
    }

    @Override
    public void registerParserFactory(IParserFactory parser) {
        if (parser instanceof KeywordParserFactory) {
            KeywordParserFactory kp = (KeywordParserFactory)parser;
            IKeyword kw = kp.keyword();
            if (kw.isRegexp()) {
                this.keywords2.put(kw.toString(), kp);
            } else {
                this.keywords.put(kw.toString(), kp);
            }
        } else if (!this.freeParsers.contains(parser)) {
            this.freeParsers.add(parser);
        }
    }

    private void registerBuildInParsers() {
        for (Class<?> c : this.buildInParserClasses()) {
            if (Modifier.isAbstract(c.getModifiers())) continue;
            Class<?> c0 = c;
            try {
                Constructor<?> ct = c0.getConstructor(new Class[0]);
                ct.setAccessible(true);
                IParserFactory f = (IParserFactory)ct.newInstance(new Object[0]);
                this.registerParserFactory(f);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public IParser createBuildInParser(String keyword, IContext context) {
        KeywordParserFactory f = this.keywords.get(keyword);
        if (null == f) {
            for (String r : this.keywords2.keySet()) {
                if (!keyword.matches(r)) continue;
                f = this.keywords2.get(r);
                break;
            }
        }
        return null == f ? null : f.create(context);
    }

    public Iterable<IParserFactory> freeParsers() {
        return new Iterable<IParserFactory>(){
            final List<IParserFactory> fs;
            {
                this.fs = new ArrayList<IParserFactory>(DialectBase.this.freeParsers);
            }

            @Override
            public Iterator<IParserFactory> iterator() {
                return new Iterator<IParserFactory>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        return this.cursor < fs.size();
                    }

                    @Override
                    public IParserFactory next() {
                        return fs.get(this.cursor++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected abstract Class<?>[] buildInParserClasses();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IDialect) {
            return this.getClass().equals(o.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public String toString() {
        return String.format("%s Dialect", this.id());
    }

    @Override
    public boolean isMyTemplate(String template) {
        return false;
    }

    @Override
    public void begin(IContext ctx) {
    }

    @Override
    public void end(IContext ctx) {
    }
}

