/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.List;

public class ExpandParser
extends KeywordParserFactory {
    private static final String R = "(^%s(%s\\s*((?@()))\\s*))";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new ParserBase(c){

            @Override
            public TextBuilder go() {
                Regex r = ExpandParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @expand statement. Correct usage: @expand(\"my-macro\")", new Object[0]);
                }
                final int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(3);
                if (S.isEmpty(s)) {
                    this.raiseParseException("Error parsing @expand statement. Correct usage: @expand(\"my-macro\")", new Object[0]);
                }
                final String macro = S.stripBraceAndQuotation(s);
                return new CodeToken(s, this.ctx()){
                    int line;
                    {
                        super(x0, x1);
                        this.line = curLine;
                    }

                    @Override
                    public void output() {
                        CodeBuilder cb = this.ctx().getCodeBuilder();
                        if (!cb.hasMacro(macro)) {
                            throw new ParseException(this.ctx().getTemplateClass(), this.line, "Cannot find macro definition for \"%s\"", macro);
                        }
                        List<TextBuilder> list = cb.getMacro(macro);
                        for (TextBuilder tb : list) {
                            tb.build();
                        }
                    }
                };
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.EXPAND;
    }

    public static void main(String[] args) {
        String s;
        ExpandParser p = new ExpandParser();
        Regex r = p.reg(new Rythm());
        if (r.search(s = "@expand(\"x.y.z\") \n@sayHi(\"green\")")) {
            ExpandParser.p(r);
        }
    }
}

