/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.play.RythmPlugin;
import com.greenlaw110.rythm.utils.IJavaExtension;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import play.Play;
import play.classloading.ApplicationClasses;
import play.templates.JavaExtensions;

public class JavaExtensionBridge {
    public static void registerAppJavaExtensions(RythmEngine engine) {
        long l = System.currentTimeMillis();
        List classes = Play.classes.getAssignableClasses(JavaExtensions.class);
        for (ApplicationClasses.ApplicationClass ac : classes) {
            Class jc = ac.javaClass;
            for (Method m : jc.getDeclaredMethods()) {
                int len;
                int flag = m.getModifiers();
                if (!Modifier.isPublic(flag) || !Modifier.isStatic(flag) || (len = m.getParameterTypes().length) <= 0) continue;
                String cn = jc.getSimpleName();
                String cn0 = jc.getName();
                String mn = m.getName();
                if (len == 1) {
                    RythmEngine.registerJavaExtension((IJavaExtension)new IJavaExtension.VoidParameterExtension(cn, mn, String.format("%s.%s", cn0, mn)));
                    continue;
                }
                RythmEngine.registerJavaExtension((IJavaExtension)new IJavaExtension.ParameterExtension(cn, mn, ".+", String.format("%s.%s", cn0, mn)));
            }
        }
        RythmPlugin.debug("%sms to register application java extension", System.currentTimeMillis() - l);
    }

    public static void registerPlayBuiltInJavaExtensions(RythmEngine engine) {
        long l = System.currentTimeMillis();
        String[] voidExtensions = new String[]{"enumValues", "asXml", "eval", "format", "since", "nl2br", "urlEncode", "formatSize", "addSlashes", "pluralize", "page", "last"};
        String[] nonVoidExtensions = new String[]{"contains", "add", "remove", "pad", "format", "page", "since", "asdate", "formatCurrency", "cut", "divisibleBy", "pluralize", "slugify", "yesno", "join"};
        for (String s : voidExtensions) {
            RythmEngine.registerJavaExtension((IJavaExtension)new PlayVoidParameterExtension(s));
        }
        for (String s : nonVoidExtensions) {
            RythmEngine.registerJavaExtension((IJavaExtension)new PlayParameterExtension(s, ".+"));
        }
        RythmEngine.registerGlobalImports((String)"play.templates.JavaExtensions");
        RythmPlugin.debug("%sms to register play built-in java extension", System.currentTimeMillis() - l);
    }

    static class PlayParameterExtension
    extends IJavaExtension.ParameterExtension {
        public PlayParameterExtension(String name, String signature) {
            super("JavaExtensions", name, signature, String.format("JavaExtensions.%s", name));
        }
    }

    static class PlayVoidParameterExtension
    extends IJavaExtension.VoidParameterExtension {
        public PlayVoidParameterExtension(String name) {
            super("JavaExtensions", name, String.format("JavaExtensions.%s", name));
        }
    }
}

