/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play.parsers;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.dialect.DialectBase;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.play.parsers.PlayRythmKeyword;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IKeyword;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class MessageLookupParser
extends KeywordParserFactory {
    public IKeyword keyword() {
        return PlayRythmKeyword._M;
    }

    protected String patternStr() {
        return "^(%s%s[\\t ]*((?@())))";
    }

    protected String innerPattern() {
        return "(((?@\"\")|(?@())|(?@'')|[a-zA-Z_][\\w$_\\.]*)(?@())?)((,\\s*([0-9\\.]+|[a-zA-Z_][\\w$_\\.]*(?@())?))*)";
    }

    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                Regex r = MessageLookupParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return null;
                }
                String s = r.stringMatched();
                this.step(s.length());
                s = r.stringMatched(3);
                s = S.stripBrace((String)s);
                r = new Regex(MessageLookupParser.this.innerPattern());
                if (r.search(s)) {
                    String msgStr = r.stringMatched(1);
                    msgStr = S.stripQuotation((String)msgStr);
                    String param = r.stringMatched(3);
                    s = S.isEmpty((String)param) ? String.format("Messages.get(\"%s\")", msgStr) : String.format("Messages.get(\"%s\" %s)", msgStr, param);
                    this.ctx().getCodeBuilder().addImport("play.i18n.Messages");
                    return new CodeToken(s, this.ctx()){

                        public void output() {
                            this.p("p(").p((Object)this.s).p((Object)");");
                            this.pline();
                        }
                    };
                }
                throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing message lookup", new Object[0]);
            }
        };
    }

    public static void main(String[] args) {
        String s;
        MessageLookupParser p = new MessageLookupParser();
        Regex r = p.reg((DialectBase)new Rythm());
        if (r.search(s = "@msg(\"abc%s, %s\", ab, true) \n")) {
            System.out.println(r.stringMatched());
            s = r.stringMatched(3);
            System.out.println(">>" + s);
            s = s.substring(1).substring(0, s.length() - 2);
            System.out.println("<<" + s);
            r = new Regex(p.innerPattern());
            if (r.search(s)) {
                System.out.println("1>>" + r.stringMatched(1));
                System.out.println("2>>" + r.stringMatched(2));
                System.out.println("3>>" + r.stringMatched(3));
                System.out.println("4>>" + r.stringMatched(4));
            }
        }
    }
}

