/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class SectionParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.SECTION;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = SectionParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @section statement. Correct usage: @section(\"mySection\"){...}", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                s = S.stripBraceAndQuotation(s);
                return new SectionToken(s, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*((?@()))[\\s]*\\{?\\s*";
    }

    public static void main(String[] args) {
        Regex r = new SectionParser().reg(new Rythm());
        if (r.search("@section(\"JS\") \nab")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
        }
    }

    public class SectionToken
    extends BlockCodeToken {
        private String section;

        public SectionToken(String section, IContext context) {
            super(null, context);
            this.section = section;
        }

        @Override
        public void output() {
            this.p("\n_startSection(\"").p(this.section).p("\");\n");
        }

        @Override
        public String closeBlock() {
            return "\n_endSection();";
        }
    }
}

