/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.DialectNotSupportException;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.CaretParserFactoryBase;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;

public class NullableExpressionParser
extends CaretParserFactoryBase {
    @Override
    public IParser create(IContext ctx) {
        final IDialect dialect = ctx.getDialect();
        if (!(dialect instanceof Rythm)) {
            throw new DialectNotSupportException(dialect.id());
        }
        String caret_ = dialect.a();
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String s0;
                String caret_ = dialect.a();
                Regex r1 = new Regex(String.format(NullableExpressionParser.this.patternStr1(), caret_));
                Regex r2 = new Regex(String.format(NullableExpressionParser.this.patternStr2(), caret_));
                Regex r3 = new Regex(NullableExpressionParser.this.patternStr3());
                Regex r4 = new Regex(NullableExpressionParser.this.patternStr4());
                String s = this.remain();
                String exp = null;
                int step = 0;
                if (r1.search(s)) {
                    exp = r1.stringMatched(2);
                    step = r1.stringMatched(1).length();
                } else if (r2.search(s)) {
                    exp = r2.stringMatched(2);
                    exp = S.stripBrace(exp);
                    step = r2.stringMatched().length();
                } else {
                    return null;
                }
                exp = exp.trim();
                if (!exp.contains("?")) {
                    return null;
                }
                if (!r4.search(exp)) {
                    return null;
                }
                this.step(step);
                StringBuilder curExp = new StringBuilder();
                final ArrayList<String> statements = new ArrayList<String>();
                while (r3.search(exp) && !Token.isJavaExtension(s0 = r3.stringMatched().trim())) {
                    if (s0.endsWith("?.")) {
                        s0 = s0.replace("?.", "");
                        curExp.append(s0);
                        String e = curExp.toString();
                        curExp.append(".");
                        statements.add(e);
                        continue;
                    }
                    if (!s0.endsWith(".")) continue;
                    curExp.append(s0);
                }
                exp = exp.replaceAll("\\?", "");
                return new CodeToken(exp, this.ctx()){

                    @Override
                    public void output() {
                        this.outputExpression(statements);
                    }
                };
            }
        };
    }

    protected String patternStr1() {
        return "^(%s(([a-zA-Z_][\\w]*((?@())(?@[])?|(?@[])(?@())?)?(\\??\\.)?)+)).*";
    }

    protected String patternStr2() {
        return "^(%s((?@())))";
    }

    protected String patternStr3() {
        return "\\G([a-zA-Z_][\\w]*((?@())(?@[])?|(?@[])(?@())?)?(\\??\\.)?)";
    }

    protected String patternStr4() {
        return "^([a-zA-Z_][\\w]*((?@())(?@[])?|(?@[])(?@())?)?(\\??\\.)?)+$";
    }

    public static void main(String[] args) {
        NullableExpressionParser.main1(args);
    }

    public static void main2(String[] args) {
        String s = "app?.name\"";
        Regex r = new Regex(new NullableExpressionParser().patternStr4());
        if (r.search(s)) {
            NullableExpressionParser.p(r, 5);
        }
    }

    public static void main1(String[] args) {
        String ps = String.format(new NullableExpressionParser().patternStr1(), "@");
        System.out.println(ps);
        Regex r = new Regex(ps);
        String s = "@foo?.bar\"dsfsa";
        if (r.search(s)) {
            NullableExpressionParser.p(r, 5);
        }
    }
}

