/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.compiler;

import com.greenlaw110.rythm.IByteCodeHelper;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.CompileException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.compiler.TemplateClassManager;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class TemplateCompiler {
    private ILogger logger = Logger.get(TemplateCompiler.class);
    Map<String, Boolean> packagesCache = new HashMap<String, Boolean>();
    TemplateClassManager classCache;
    Map<String, String> settings;

    private RythmEngine engine() {
        return this.classCache.engine;
    }

    private String getTemplateByClassName(String className) {
        TemplateClass tc = this.engine().classes.getByClassName(className);
        return null == tc ? null : tc.getKey().toString();
    }

    public TemplateCompiler(TemplateClassManager classCache) {
        this.classCache = classCache;
        this.settings = new HashMap<String, String>();
        this.settings.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.settings.put("org.eclipse.jdt.core.encoding", "UTF-8");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        String javaVersion = "1.5";
        if (System.getProperty("java.version").startsWith("1.6")) {
            javaVersion = "1.6";
        } else if (System.getProperty("java.version").startsWith("1.7")) {
            javaVersion = "1.7";
        }
        this.settings.put("org.eclipse.jdt.core.compiler.source", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.settings.put("org.eclipse.jdt.core.compiler.compliance", javaVersion);
    }

    public void compile(String[] classNames) {
        ICompilationUnit[] compilationUnits = new CompilationUnit[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            compilationUnits[i] = new CompilationUnit(classNames[i]);
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(packageName[i]);
                    result.append('.');
                }
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findStandType(String name) throws ClassFormatException {
                RythmEngine engine = TemplateCompiler.this.engine();
                IByteCodeHelper helper = engine.byteCodeHelper;
                byte[] bytes = engine.classLoader.getClassDefinition(name);
                if (null == bytes && null != helper) {
                    bytes = helper.findByteCode(name);
                }
                if (bytes != null) {
                    ClassFileReader classFileReader = new ClassFileReader(bytes, name.toCharArray(), true);
                    return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
                return null;
            }

            private NameEnvironmentAnswer findType(String name) {
                try {
                    if (!name.contains("__R_T_C__")) {
                        return this.findStandType(name);
                    }
                    char[] fileName = name.toCharArray();
                    TemplateClass templateClass = TemplateCompiler.this.classCache.getByClassName(name);
                    if (templateClass != null) {
                        if (templateClass.javaByteCode != null) {
                            ClassFileReader classFileReader = new ClassFileReader(templateClass.javaByteCode, fileName, true);
                            return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(name);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                    }
                    return this.findStandType(name);
                }
                catch (ClassFormatException e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder sb = new StringBuilder();
                if (parentPackageName != null) {
                    for (char[] p : parentPackageName) {
                        sb.append(new String(p));
                        sb.append(".");
                    }
                }
                sb.append(new String(packageName));
                String name = sb.toString();
                if (TemplateCompiler.this.packagesCache.containsKey(name)) {
                    return TemplateCompiler.this.packagesCache.get(name);
                }
                if (((TemplateCompiler)TemplateCompiler.this).engine().classLoader.getClassDefinition(name) != null) {
                    TemplateCompiler.this.packagesCache.put(name, false);
                    return false;
                }
                if (((TemplateCompiler)TemplateCompiler.this).engine().classes.getByClassName(name) != null) {
                    TemplateCompiler.this.packagesCache.put(name, false);
                    return false;
                }
                TemplateCompiler.this.packagesCache.put(name, true);
                return true;
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                CategorizedProblem[] arr$;
                int len$;
                int i$;
                if (result.hasErrors() && (i$ = 0) < (len$ = (arr$ = result.getErrors()).length)) {
                    CategorizedProblem problem = arr$[i$];
                    int line = problem.getSourceLineNumber();
                    int column = problem.getSourceStart();
                    String message = problem.getMessage();
                    throw CompileException.compilerException(String.valueOf(result.compilationUnit.getMainTypeName()), line, message);
                }
                ClassFile[] clazzFiles = result.getClassFiles();
                for (int i = 0; i < clazzFiles.length; ++i) {
                    String cn;
                    TemplateClass tc;
                    ClassFile clazzFile = clazzFiles[i];
                    char[][] compoundName = clazzFile.getCompoundName();
                    StringBuffer clazzName = new StringBuffer();
                    for (int j = 0; j < compoundName.length; ++j) {
                        if (j != 0) {
                            clazzName.append('.');
                        }
                        clazzName.append(compoundName[j]);
                    }
                    if (TemplateCompiler.this.logger.isTraceEnabled()) {
                        TemplateCompiler.this.logger.trace("Compiled %s", TemplateCompiler.this.getTemplateByClassName(clazzName.toString()));
                    }
                    if (null == (tc = TemplateCompiler.this.classCache.getByClassName(cn = clazzName.toString()))) {
                        int pos = cn.indexOf("$");
                        if (-1 != pos) {
                            TemplateClass root = TemplateCompiler.this.classCache.getByClassName(cn.substring(0, pos));
                            tc = TemplateClass.createInnerClass(cn, clazzFile.getBytes(), root);
                            tc.delayedEnhance(root);
                            TemplateCompiler.this.classCache.add(tc);
                            ((TemplateCompiler)TemplateCompiler.this).engine().classCache.cacheTemplateClass(tc);
                            continue;
                        }
                        throw new RuntimeException("Cannot find class by name: " + cn);
                    }
                    tc.compiled(clazzFile.getBytes());
                }
            }
        };
        Compiler jdtCompiler = new Compiler(nameEnvironment, policy, this.settings, compilerRequestor, (IProblemFactory)problemFactory){

            protected void handleInternalException(Throwable e, CompilationUnitDeclaration ud, CompilationResult result) {
            }
        };
        jdtCompiler.compile(compilationUnits);
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;

        CompilationUnit(String pClazzName) {
            this.clazzName = pClazzName;
            if (pClazzName.contains("$")) {
                pClazzName = pClazzName.substring(0, pClazzName.indexOf("$"));
            }
            this.fileName = pClazzName.replace('.', '/') + ".java";
            int dot = pClazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? pClazzName.substring(dot + 1).toCharArray() : pClazzName.toCharArray();
            StringTokenizer st = new StringTokenizer(pClazzName, ".");
            this.packageName = new char[st.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = st.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            if (null == TemplateCompiler.this.classCache) {
                throw new NullPointerException("classCache is null");
            }
            TemplateClass tc = TemplateCompiler.this.classCache.getByClassName(this.clazzName);
            if (null == tc) {
                throw new NullPointerException("Error get java source content for " + this.clazzName + ": template class is null");
            }
            if (null == tc.javaSource) {
                throw new NullPointerException("Error get java source content for " + this.clazzName + ": java source is null");
            }
            return tc.javaSource.toCharArray();
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

