/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.dialect;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.AutoToStringCodeBuilder;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.dialect.ToString;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.template.ToStringTemplateBase;
import com.greenlaw110.rythm.toString.ToStringOption;
import com.greenlaw110.rythm.toString.ToStringStyle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoToString
extends ToString {
    public AutoToStringData meta = null;
    private static final Pattern P = Pattern.compile("\\{class *: *([a-zA-Z_0-9\\.\\$]+) *; *toStringOption *: *(\\{.*?\\}) *; *toStringStyle *: *([a-zA-Z_0-9\\.\\$]+) *\\}");

    @Override
    public String id() {
        return "autoToString";
    }

    public AutoToString(Class type, AutoToStringData data) {
        super(type);
        this.meta = data;
    }

    @Override
    public void begin(IContext ctx) {
        CodeBuilder cb = ctx.getCodeBuilder();
        cb.addRenderArgs(this.type.getName(), "_");
        cb.setSimpleTemplate(0);
        cb.setExtended(ToStringTemplateBase.class);
    }

    @Override
    public CodeBuilder createCodeBuilder(String template, String className, String tagName, TemplateClass templateClass, RythmEngine engine) {
        return new AutoToStringCodeBuilder(template, className, tagName, templateClass, engine, this);
    }

    public static String templateStr(Class<?> c, ToStringOption o, ToStringStyle s) {
        return Rythm.render("{class: @c; toStringOption: @o; toStringStyle: @s}", null == c ? "" : c.getName(), o.toString(), s.toString());
    }

    public static AutoToStringData parseStr(String s) {
        Matcher m = P.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Unrecognized AutoToString template: " + s);
        }
        String cs = m.group(1);
        String os = m.group(2);
        String ss = m.group(3);
        Class<?> c = null;
        try {
            c = Rythm.engine().classLoader.loadClass(cs);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + cs);
        }
        ToStringOption o = ToStringOption.valueOf(os);
        ToStringStyle st = ToStringStyle.valueOf(ss);
        return new AutoToStringData(c, o, st);
    }

    public static void main(String[] args) {
        String s = AutoToString.templateStr(String.class, ToStringOption.defaultOption.setAppendTransient(true), ToStringStyle.DEFAULT_STYLE);
        System.out.println(s);
        AutoToStringData d = AutoToString.parseStr(s);
        System.out.println(d);
    }

    public static class AutoToStringData {
        public Class<?> clazz;
        public ToStringOption option = ToStringOption.defaultOption;
        public ToStringStyle style = ToStringStyle.DEFAULT_STYLE;
        private int hash = 0;

        public AutoToStringData(Class<?> clazz, ToStringOption option, ToStringStyle style) {
            this.clazz = clazz;
            if (null != option) {
                this.option = option;
            }
            if (null != style) {
                this.style = style;
            }
        }

        public String toString() {
            return AutoToString.templateStr(this.clazz, this.option, this.style);
        }

        public int hashCode() {
            if (0 == this.hash) {
                this.hash = ((31 + this.clazz.hashCode()) * 17 + this.option.hashCode()) * 17 + this.style.hashCode();
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AutoToStringData) {
                AutoToStringData that = (AutoToStringData)obj;
                return that.clazz.equals(this.clazz) && that.option.equals(this.option) && that.style.equals(this.style);
            }
            return false;
        }

        public static AutoToStringData valueOf(String s) {
            return AutoToString.parseStr(s);
        }
    }
}

