/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.runtime;

import com.greenlaw110.rythm.internal.TemplateBuilder;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.utils.S;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface ITag
extends ITemplate {
    public String getName();

    public void call();

    public static abstract class Body
    extends TemplateBuilder {
        protected ILogger logger = Logger.get(ITag.class);
        protected TemplateBase _context;

        public Body(TemplateBase context) {
            this._context = context;
        }

        @Override
        public StringBuilder getOut() {
            return this._out;
        }

        public ITemplate getContext() {
            return this._context;
        }

        @Override
        public void setOut(StringBuilder out) {
        }

        private void call(StringBuilder out) {
            this._out = out;
            this._call();
            this._out = null;
        }

        public final Body pe(Object o) {
            if (null == o) {
                return this;
            }
            if (o instanceof ITemplate.RawData) {
                return (Body)this.p(o);
            }
            ITemplate.Escape escape = this._context.__ctx.currentEscape();
            return (Body)this.pe(o, escape);
        }

        protected abstract void setBodyArgByName(String var1, Object var2);

        protected abstract void setBodyArgByPos(int var1, Object var2);

        public String render(Object ... vals) {
            StringBuilder sb = new StringBuilder();
            this.render(sb, vals);
            return sb.toString();
        }

        public void render(StringBuilder out, Object ... vals) {
            for (int i = vals.length - 1; i > -1; --i) {
                this.setBodyArgByPos(i, vals[i]);
            }
            this.call(out);
        }

        public void render(ParameterList parameterList, StringBuilder out) {
            if (null != parameterList) {
                for (int i = 0; i < parameterList.size(); ++i) {
                    Parameter p = parameterList.get(i);
                    if (!S.isEmpty(p.name)) {
                        this.setBodyArgByName(p.name, p.value);
                        continue;
                    }
                    this.setBodyArgByPos(i, p.value);
                }
            }
            this.call(out);
        }

        protected abstract void _call();

        public abstract void setProperty(String var1, Object var2);

        public abstract Object getProperty(String var1);
    }

    public static class ParameterList
    implements Iterable<Parameter> {
        private List<Parameter> lp = new ArrayList<Parameter>();
        private String uuid = null;

        public void add(String name, Object value) {
            this.lp.add(new Parameter(name, value));
        }

        public Object getByName(String name) {
            for (Parameter para : this.lp) {
                if (!name.equals(para.name)) continue;
                return para.value;
            }
            return null;
        }

        public <T> T getByName(String name, T defVal) {
            for (Parameter para : this.lp) {
                if (!name.equals(para.name)) continue;
                return (T)para.value;
            }
            return defVal;
        }

        public Object getDefault() {
            return this.getByPosition(0);
        }

        public Object getByPosition(int pos) {
            if (pos >= this.lp.size()) {
                return null;
            }
            return this.lp.get((int)pos).value;
        }

        @Override
        public Iterator<Parameter> iterator() {
            return this.lp.iterator();
        }

        public int size() {
            return this.lp.size();
        }

        public Parameter get(int i) {
            return this.lp.get(i);
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Parameter p : this.lp) {
                if (p.name == null) continue;
                m.put(p.name, p.value);
            }
            return m;
        }

        public String toUUID() {
            if (null == this.uuid) {
                StringBuilder sb = new StringBuilder();
                for (Parameter p : this.lp) {
                    sb.append(";").append(p.name).append("=").append(p.value);
                }
                String s = sb.toString();
                if (S.isEmpty(s)) {
                    s = "EMPTY_PARAMETER_LIST";
                }
                this.uuid = UUID.nameUUIDFromBytes(s.getBytes()).toString();
            }
            return this.uuid;
        }
    }

    public static class Parameter {
        public String name;
        public Object value;

        public Parameter(String name, Object value) {
            this.name = "".equals(name) ? null : name;
            this.value = value;
        }

        public String toString() {
            return "[" + this.name + "]:" + this.value;
        }
    }
}

