/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play.utils;

import com.greenlaw110.rythm.play.RythmPlugin;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Play;
import play.exceptions.NoRouteFoundException;
import play.libs.IO;
import play.mvc.Http;
import play.vfs.VirtualFile;

public class StaticRouteResolver {
    private static Map<String, String> routes = new HashMap<String, String>();
    private static List<String> urlList = new ArrayList<String>();

    public static String reverseWithCheck(String name, boolean absolute) {
        VirtualFile file = Play.getVirtualFile((String)name);
        if (file == null || !file.exists()) {
            return StaticRouteResolver.verify(name, absolute);
        }
        return StaticRouteResolver.reverse(file, absolute);
    }

    private static String getBaseUrl() {
        if (Http.Request.current() == null) {
            String appBaseUrl = Play.configuration.getProperty("application.baseUrl", "application.baseUrl");
            if (appBaseUrl.endsWith("/")) {
                appBaseUrl = appBaseUrl.substring(0, appBaseUrl.length() - 1);
            }
            return appBaseUrl;
        }
        return Http.Request.current().getBase();
    }

    private static String reverse(VirtualFile file, boolean absolute) {
        String path = file.relativePath();
        path = path.substring(path.indexOf("}") + 1);
        for (String url : urlList) {
            String staticDir = routes.get(url);
            if (!staticDir.startsWith("/")) {
                staticDir = "/" + staticDir;
            }
            if (!staticDir.equals("/") && !staticDir.endsWith("/")) {
                staticDir = staticDir + "/";
            }
            if (!path.startsWith(staticDir)) continue;
            String to = url + path.substring(staticDir.length());
            if (to.endsWith("/index.html")) {
                to = to.substring(0, to.length() - "/index.html".length() + 1);
            }
            if (absolute) {
                boolean isSecure = Http.Request.current() == null ? false : Http.Request.current().secure;
                String base = StaticRouteResolver.getBaseUrl();
                to = base + to;
            }
            return to;
        }
        throw new NoRouteFoundException(file.relativePath());
    }

    private static String verify(String name, boolean absolute) {
        String path = name;
        for (String url : urlList) {
            String to;
            VirtualFile vf;
            String staticDir;
            if (!path.startsWith(url) || (staticDir = routes.get(url)) == null) continue;
            if (!staticDir.startsWith("/")) {
                staticDir = "/" + staticDir;
            }
            if (!staticDir.equals("/") && !staticDir.endsWith("/")) {
                staticDir = staticDir + "/";
            }
            if (null == (vf = Play.getVirtualFile((String)(to = path.replaceFirst(url, staticDir)))) || !vf.exists()) {
                throw new NoRouteFoundException(name);
            }
            if (to.endsWith("/index.html")) {
                to = to.substring(0, to.length() - "/index.html".length() + 1);
            }
            if (absolute) {
                boolean isSecure = Http.Request.current() == null ? false : Http.Request.current().secure;
                String base = StaticRouteResolver.getBaseUrl();
                return base + name;
            }
            return name;
        }
        throw new NoRouteFoundException(name);
    }

    public static void loadStaticRoutes() {
        String prefix = Play.ctxPath;
        if (null == prefix || "/".equals(prefix)) {
            prefix = "";
        }
        StaticRouteResolver.parse(Play.getVirtualFile((String)"conf/routes"), prefix);
    }

    private static void parse(VirtualFile vf, String prefix) {
        List ls = IO.readLines((InputStream)vf.inputstream());
        for (String s : ls) {
            if ((s = s.trim()).startsWith("#")) continue;
            if (s.contains("module:")) {
                StaticRouteResolver.importModule(s, prefix);
            }
            if (!s.contains("staticDir:") && !s.contains("staticFile:")) continue;
            StaticRouteResolver.parseLine(s, prefix, vf);
        }
    }

    private static void importModule(String line, String prefix) {
        String moduleName;
        String[] sa = line.split("\\s+");
        if (sa.length != 3) {
            RythmPlugin.warn("invalid route line: %s", line);
            return;
        }
        String url = sa[1];
        String newPrefix = prefix + url;
        if (newPrefix.length() > 1 && newPrefix.endsWith("/")) {
            newPrefix = newPrefix.substring(0, newPrefix.length() - 1);
        }
        if ("*".equals(moduleName = sa[2].substring("module:".length()))) {
            for (String p : Play.modulesRoutes.keySet()) {
                StaticRouteResolver.parse((VirtualFile)Play.modulesRoutes.get(p), newPrefix + p);
            }
        } else if (Play.modulesRoutes.containsKey(moduleName)) {
            StaticRouteResolver.parse((VirtualFile)Play.modulesRoutes.get(moduleName), newPrefix);
        }
    }

    private static void parseLine(String line, String prefix, VirtualFile routesConf) {
        VirtualFile vf;
        String path;
        String[] sa = line.split("\\s+");
        if (sa.length != 3) {
            RythmPlugin.warn("invalid route line: %s", line);
            return;
        }
        String url = prefix + sa[1];
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if ((path = sa[2]).contains("staticDir:")) {
            path = path.substring("staticDir:".length());
        } else if (path.contains("staticFile:")) {
            path = path.substring("staticFile:".length());
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((vf = Play.getVirtualFile((String)path)) == null || !vf.exists()) {
            RythmPlugin.error("Bad routes file [%s]: staticDir[%s] not found", routesConf.relativePath(), path);
            return;
        }
        routes.put(url, vf.relativePath());
        if (!urlList.contains(url)) {
            urlList.add(url);
        }
    }
}

