/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.DialectBase;
import com.greenlaw110.rythm.internal.parser.Directive;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;

public class ArgsParser
extends KeywordParserFactory {
    public static final String PATTERN = "\\G[ \\t\\x0B\\f]*,?[ \\t\\x0B\\f]*(([\\sa-zA-Z_][\\w$_\\.]*(?@\\<\\>)?(\\[\\])?)[ \\t\\x0B\\f]+([a-zA-Z_][\\w$_]*))([ \\t\\x0B\\f]*=[ \\t\\x0B\\f]*((?@{})|[0-9]|'[.]'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))?";
    public static final String PATTERN2 = "";

    @Override
    public Keyword keyword() {
        return Keyword.ARGS;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go2(String s) {
                Regex r = ArgsParser.this.reg(this.dialect());
                final ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
                s = s.replaceAll("[\\n\\r]+", ",");
                while (r.search(s)) {
                    String matched = r.stringMatched();
                    String name = r.stringMatched(4);
                    String type = r.stringMatched(2);
                    String defVal = r.stringMatched(6);
                    ral.add(new CodeBuilder.RenderArgDeclaration(name, type, defVal));
                }
                return new Directive(ArgsParser.PATTERN2, this.ctx()){

                    @Override
                    public void call() {
                        for (CodeBuilder.RenderArgDeclaration rd : ral) {
                            this.builder().addRenderArgs(rd);
                        }
                    }
                };
            }

            @Override
            public TextBuilder go() {
                String matched;
                String remain = this.remain();
                Regex r = new Regex(String.format("%s%s(\\([ \t\f]*\\))?[ \t\f]*((?@{}))", this.a(), ArgsParser.this.keyword()));
                if (r.search(remain)) {
                    String s = r.stringMatched(2);
                    s = S.strip(s, "{", "}");
                    this.step(r.stringMatched().length());
                    return this.go2(s);
                }
                String key = String.format("%s%s ", this.a(), ArgsParser.this.keyword());
                if (!remain.startsWith(key)) {
                    this.raiseParseException("No argument declaration found", new Object[0]);
                }
                this.step(key.length());
                remain = this.remain();
                r = ArgsParser.this.reg(this.dialect());
                int step = 0;
                final ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
                while (r.search(remain) && !(matched = r.stringMatched()).startsWith("\n") && !matched.startsWith("\r")) {
                    step += matched.length();
                    String name = r.stringMatched(4);
                    String type = r.stringMatched(2);
                    String defVal = r.stringMatched(6);
                    ral.add(new CodeBuilder.RenderArgDeclaration(name, type, defVal));
                }
                this.step(step);
                char c = this.peek();
                while ((' ' == (c = this.peek()) || ';' == c || '\r' == c || '\n' == c) && ctx.hasRemain()) {
                    this.step(1);
                }
                return new Directive(ArgsParser.PATTERN2, this.ctx()){

                    @Override
                    public void call() {
                        for (CodeBuilder.RenderArgDeclaration rd : ral) {
                            this.builder().addRenderArgs(rd);
                        }
                    }
                };
            }
        };
    }

    public static List<CodeBuilder.RenderArgDeclaration> parseArgDeclaration(String s) {
        String matched;
        ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
        Regex r = new ArgsParser().reg((DialectBase)Rythm.getDialectManager().get());
        while (r.search(s) && !(matched = r.stringMatched()).startsWith("\n") && !matched.startsWith("\r")) {
            String name = r.stringMatched(4);
            String type = r.stringMatched(2);
            String defVal = r.stringMatched(5);
            ral.add(new CodeBuilder.RenderArgDeclaration(name, type, defVal));
        }
        return ral;
    }

    @Override
    protected String patternStr() {
        return PATTERN;
    }

    protected String patternStr0() {
        return "(%s%s([\\s,]+[a-zA-Z][a-zA-Z0-9_\\.]*(\\<[a-zA-Z][a-zA-Z0-9_\\.,]*\\>)?[\\s]+[a-zA-Z][a-zA-Z0-9_\\.]*)+(;|\\r?\\n)+).*";
    }

    public static void main(String[] args) {
        ArgsParser.test1();
    }

    public static void test2() {
        Regex r = new Regex("@args(\\([ \t\f]*\\))?[ \t\f]*((?@{}))");
        String s = "@args() {\nString s = 1}";
        ArgsParser.p(s, r);
    }

    public static void test1() {
        String m;
        String s = ",String,foo,=,\"bar\",int,bar,=,5;,";
        ArgsParser ap = new ArgsParser();
        Regex r = ap.reg(new com.greenlaw110.rythm.internal.dialect.Rythm());
        while (r.search(s) && !(m = r.stringMatched()).contains("\n") && !m.contains("\r")) {
            System.out.println("m: " + m.toCharArray()[0]);
            ArgsParser.p(r, 10);
        }
    }
}

