/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.ExecMacroToken;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class ExpandParser
extends KeywordParserFactory {
    private static final String R = "(^%s(%s\\s*((?@()))\\s*))";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new ParserBase(c){

            @Override
            public TextBuilder go() {
                Regex r = ExpandParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @expand statement. Correct usage: @expand(\"my-macro\")", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(3);
                if (S.isEmpty(s)) {
                    this.raiseParseException("Error parsing @expand statement. Correct usage: @expand(\"my-macro\")", new Object[0]);
                }
                String macro = S.stripBraceAndQuotation(s);
                return new ExecMacroToken(macro, this.ctx(), curLine);
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.EXPAND;
    }

    public static void main(String[] args) {
        String s;
        ExpandParser p = new ExpandParser();
        Regex r = p.reg(new Rythm());
        if (r.search(s = "@expand(\"x.y.z\") \n@sayHi(\"green\")")) {
            ExpandParser.p(r);
        }
    }
}

