/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.TemplateParser;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.Patterns;
import com.greenlaw110.rythm.internal.parser.build_in.ArgsParser;
import com.greenlaw110.rythm.internal.parser.build_in.CacheParser;
import com.greenlaw110.rythm.internal.parser.build_in.CaretParserFactoryBase;
import com.greenlaw110.rythm.spi.IBlockHandler;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InvokeTagParser
extends CaretParserFactoryBase {
    static final Pattern P_HEREDOC_SIMBOL = Pattern.compile("(\\s*<<).*", 32);
    static final Pattern P_STANDARD_BLOCK = Pattern.compile("(\\s*\\{).*", 32);

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            String testTag(String name) {
                return this.ctx().getCodeBuilder().engine.testTag(name, this.ctx().getTemplateClass());
            }

            @Override
            public TextBuilder go() {
                Regex r = new Regex(String.format(InvokeTagParser.patternStr(), this.dialect().a()));
                if (!r.search(this.remain())) {
                    return null;
                }
                String tagName = r.stringMatched(2);
                if (null == (tagName = this.testTag(tagName))) {
                    return null;
                }
                tagName = "\"" + tagName + "\"";
                String s = r.stringMatched();
                this.ctx().step(s.length());
                s = this.remain();
                Matcher m0 = P_HEREDOC_SIMBOL.matcher(s);
                Matcher m1 = P_STANDARD_BLOCK.matcher(s);
                if (m0.matches()) {
                    this.ctx().step(m0.group(1).length());
                    return new InvokeTagWithBodyToken(tagName, r.stringMatched(3), r.stringMatched(4), this.ctx());
                }
                if (m1.matches()) {
                    this.ctx().step(m1.group(1).length());
                    return new InvokeTagWithBodyToken(tagName, r.stringMatched(3), r.stringMatched(4), this.ctx());
                }
                return new InvokeTagToken(tagName, r.stringMatched(3), r.stringMatched(4), this.ctx());
            }
        };
    }

    private static String patternStr() {
        return "^(%s([_a-zA-Z][a-zA-Z$_\\.0-9]+)\\s*((?@()))((\\.([_a-zA-Z][_a-zA-Z0-9]*)((?@())))*))";
    }

    private static void testParseParams() {
        String line = "ls";
        Regex r = new Regex("\\G(,\\s*)?((([a-zA-Z_][\\w$_]*)\\s*[=:]\\s*)?('.'|(?@\"\")|[0-9\\.]+[l]?|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*)|[_a-zA-Z][a-z_A-Z0-9]*)");
        InvokeTagParser.p(line, r);
    }

    private static void testParseExtension() {
        Regex r = new Regex("\\G(\\.)([_a-zA-Z]+)((?@()))");
        String line = ".cache(\"1h\", foo.bar(), x, 32).callback(String name).escape(\"HTML\")";
        InvokeTagParser.p(line, r);
    }

    private static void testOuterMatch() {
        TemplateParser ctx = new TemplateParser(new CodeBuilder(null, "", null, null, null, null));
        new InvokeTagParser();
        String ps = String.format(InvokeTagParser.patternStr(), "@");
        Regex r = new Regex(ps);
        String s = "@xyz(xyz: zbc, y=component.left[bar.get(bar[123]).foo(\" hello\")].get(v[3])[3](), \"hp\").cache(ab, d).escape()  Gren";
        if (r.search(s)) {
            InvokeTagParser.p(r, 7);
        } else {
            System.out.println("not found");
        }
    }

    public static void main(String[] args) {
        InvokeTagParser.testParseExtension();
    }

    static class InvokeTagWithBodyToken
    extends InvokeTagToken
    implements IBlockHandler {
        private String textListenerKey = UUID.randomUUID().toString();
        private StringBuilder tagBodyBuilder = new StringBuilder();
        private int startIndex = 0;
        private int endIndex = 0;
        private String key = null;
        private String cacheKey = null;

        InvokeTagWithBodyToken(String tagName, String paramLine, String extLine, IContext context) {
            super(tagName, paramLine, extLine, context, true);
            context.openBlock(this);
            this.startIndex = this.ctx.cursor();
        }

        @Override
        protected String cacheKey() {
            if (null == this.cacheKey) {
                this.cacheKey = !this.isDynamic ? "\"" + UUID.nameUUIDFromBytes(("_RYTHM_TAG_" + this.tagName + this.key + this.ctx.getTemplateClass().name()).getBytes()).toString() + "\"" : "\"_RYTHM_TAG_\" + " + this.tagName + " + \"" + this.key + "\"" + " + \"" + this.ctx.getTemplateClass().name() + "\"";
            }
            return this.cacheKey;
        }

        @Override
        public void openBlock() {
            this.ctx.pushInsideBody2(true);
            CodeBuilder cb = this.ctx.getCodeBuilder();
            cb.addBuilder(new Token("", this.ctx){

                @Override
                protected void output() {
                    this.ctx.pushInsideBody(true);
                    super.output();
                }
            });
        }

        @Override
        public void output() {
            if (this.assignTo != null) {
                this.ptline("Object ", new Object[0]).p(this.assignTo).p(" = null;");
            }
            this.pline("{", new Object[0]);
            this.ptline("com.greenlaw110.rythm.runtime.ITag.ParameterList _pl = null; ", new Object[0]);
            if (this.params.pl.size() > 0) {
                this.ptline("_pl = new com.greenlaw110.rythm.runtime.ITag.ParameterList();", new Object[0]);
                for (int i = 0; i < this.params.pl.size(); ++i) {
                    ParameterDeclaration pd = this.params.pl.get(i);
                    this.pt("_pl.add(\"").p(pd.nameDef == null ? "" : pd.nameDef).p("\",").p(pd.valDef).p(");");
                    this.pline();
                }
            }
            String curClassName = this.ctx.getCodeBuilder().includingClassName();
            if (this.needsNewOut()) {
                this.pline("Object _r_s = null;", new Object[0]);
                if (this.enableCache) {
                    this.ptline("String _plUUID = null == _pl ? \"\" : _pl.toUUID();", new Object[0]);
                    this.pt("_r_s = _engine().cached(").p(this.cacheKey()).p(this.cacheArgs).p(");");
                    this.pline();
                }
                this.ptline("if (null == _r_s) {", new Object[0]);
                this.p2tline("StringBuilder sbOld = getOut();", new Object[0]);
                this.p2tline("StringBuilder sbNew = new StringBuilder();", new Object[0]);
                this.p2tline("setSelfOut(sbNew);", new Object[0]);
            }
            this.p2t("_invokeTag(").p(this.tagName).p(", _pl,  new com.greenlaw110.rythm.runtime.ITag.Body(").p(curClassName).p(".this) {");
            this.pline();
            if (null != this.argList && !this.argList.isEmpty()) {
                this.buildBodyArgList(this.argList);
            }
            this.p3tline("@Override public void setProperty(String name, Object val) {", new Object[0]);
            this.p4tline("setRenderArg(name, val);", new Object[0]);
            this.p3tline("}", new Object[0]);
            this.p3tline("@Override public Object getProperty(String name) {", new Object[0]);
            this.p4tline("return getRenderArg(name); ", new Object[0]);
            this.p3tline("}", new Object[0]);
            this.p3tline("@Override protected void setBodyArgByName(String name, Object val) {", new Object[0]);
            if (null != this.argList && !this.argList.isEmpty()) {
                this.buildSetBodyArgByName(this.argList);
            }
            this.p3tline("}", new Object[0]);
            this.p3tline("@Override protected void setBodyArgByPos(int pos, Object val) {", new Object[0]);
            if (null != this.argList && !this.argList.isEmpty()) {
                this.buildSetBodyArgByPos(this.argList);
            }
            this.p3tline("}", new Object[0]);
            this.p3tline("@Override protected void _call() {", new Object[0]);
        }

        private void buildBodyArgList(List<CodeBuilder.RenderArgDeclaration> al) {
            for (CodeBuilder.RenderArgDeclaration arg : al) {
                this.p3t("protected ").p(arg.type).p(" ").p(arg.name);
                if (null != arg.defVal) {
                    this.p("=").p(arg.defVal).p(";");
                } else {
                    this.p(";");
                }
                this.pline();
            }
        }

        private void buildSetBodyArgByName(List<CodeBuilder.RenderArgDeclaration> al) {
            for (CodeBuilder.RenderArgDeclaration arg : al) {
                this.p4t("if (\"").p(arg.name).p("\".equals(name)) this.").p(arg.name).p("=(").p(arg.type).p(")val;");
                this.pline();
            }
        }

        private void buildSetBodyArgByPos(List<CodeBuilder.RenderArgDeclaration> al) {
            this.p4tline("int p = 0;", new Object[0]);
            for (CodeBuilder.RenderArgDeclaration arg : al) {
                this.p4t("if (p++ == pos) { Object v = val; boolean isString = (\"java.lang.String\".equals(\"").p(arg.type).p("\") || \"String\".equals(\"").p(arg.type).p("\")); ").p(arg.name).p(" = (").p(arg.type).p(")(isString ? (null == v ? \"\" : v.toString()) : v); }");
                this.pline();
            }
        }

        @Override
        public String closeBlock() {
            this.ctx.popInsideBody2();
            this.ctx.getCodeBuilder().addBuilder(new Token("", this.ctx){

                @Override
                protected void output() {
                    this.ctx.popInsideBody();
                    super.output();
                }
            });
            if (!this.needsNewOut()) {
                if (this.ctx.peekInsideBody2().booleanValue()) {
                    return "\n\t\t}\n\t}, self);\n}";
                }
                return "\n\t\t}\n\t});\n}";
            }
            if (this.enableCache) {
                this.endIndex = this.ctx.cursor();
                String body = this.ctx.getTemplateSource(this.startIndex, this.endIndex);
                this.key = UUID.nameUUIDFromBytes(body.getBytes()).toString();
            }
            StringBuilder sbOld = this.getOut();
            StringBuilder sbNew = new StringBuilder();
            this.setOut(sbNew);
            this.p3tline("}", new Object[0]);
            if (this.ctx.peekInsideBody2().booleanValue()) {
                this.p2t("}, self, ").p(this.ignoreNonExistsTag).p(");");
            } else {
                this.p2t("}, ").p(this.ignoreNonExistsTag).p(");");
            }
            this.pline();
            this.p2tline("_r_s = sbNew.toString();", new Object[0]);
            this.p2tline("setSelfOut(sbOld);", new Object[0]);
            if (this.escape != null) {
                this.p2tline(String.format("_r_s = com.greenlaw110.rythm.template.ITemplate.Escape.%s.apply(_r_s);", this.escape.name()), new Object[0]);
            }
            if (this.enableCache) {
                this.p2t("_engine().cache(").p(this.cacheKey()).p(", _r_s, ").p(this.cacheDuration).p(this.cacheArgs).p(");");
                this.pline();
            }
            this.ptline("}", new Object[0]);
            if (this.assignTo != null) {
                this.pt(this.assignTo).p(" = _r_s;");
                this.pline();
            } else {
                this.ptline("p(_r_s);", new Object[0]);
            }
            this.p2tline("}", new Object[0]);
            String s = sbNew.toString();
            this.setOut(sbOld);
            return s;
        }
    }

    static class InvokeTagToken
    extends CodeToken {
        protected boolean isDynamic = false;
        protected String tagName;
        private boolean enableCallback = false;
        ParameterDeclarationList params = new ParameterDeclarationList();
        protected boolean enableCache = false;
        protected String cacheDuration = null;
        protected String cacheArgs = null;
        protected ITemplate.Escape escape = null;
        protected boolean ignoreNonExistsTag = false;
        protected String assignTo = null;
        protected boolean assignToFinal = false;
        protected List<CodeBuilder.RenderArgDeclaration> argList = null;
        private String cacheKey = null;

        static InvokeTagToken dynamicTagToken(String tagName, String paramLine, String extLine, IContext context) {
            InvokeTagToken t = new InvokeTagToken(tagName, paramLine, extLine, context);
            t.isDynamic = true;
            return t;
        }

        static InvokeTagToken dynamicTagToken(String tagName, String paramLine, String extLine, IContext context, boolean enableCallback) {
            InvokeTagToken t = new InvokeTagToken(tagName, paramLine, extLine, context, enableCallback);
            t.isDynamic = true;
            return t;
        }

        InvokeTagToken(String tagName, String paramLine, String extLine, IContext context) {
            this(tagName, paramLine, extLine, context, false);
        }

        InvokeTagToken(String tagName, String paramLine, String extLine, IContext context, boolean enableCallback) {
            super(null, context);
            this.tagName = tagName;
            this.enableCallback = enableCallback;
            this.parseParams(paramLine);
            this.parseExtension(extLine);
        }

        private void parseParams(String line) {
            InvokeTagToken.parseParams(line, this.params);
        }

        static void parseParams(String line, ParameterDeclarationList params) {
            if (S.isEmpty(line)) {
                return;
            }
            if ((line = line.trim()).startsWith("(")) {
                line = S.stripBrace(line);
            }
            Regex r = new Regex("\\G(\\s*,\\s*)?((([a-zA-Z_][\\w$_]*)\\s*[=:]\\s*)?((?@())|'.'|(?@\"\")|[0-9\\.]+[l]?|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*)|[_a-zA-Z][a-z_A-Z0-9]*)");
            line = line.replaceAll("^\\s+", "");
            line = S.strip(line, "{", "}");
            line = line.replaceAll("^\\s+", "");
            while (r.search(line)) {
                params.addParameterDeclaration(r.stringMatched(4), r.stringMatched(5));
            }
        }

        private void parseExtension(String line) {
            if (S.isEmpty(line)) {
                return;
            }
            Regex r = new Regex("\\G(\\.)([_a-zA-Z][_a-zA-Z0-9]*)((?@()))");
            while (r.search(line)) {
                String group = r.stringMatched();
                String extension = r.stringMatched(2);
                String param = S.stripBrace(r.stringMatched(3));
                if ("cache".equals(extension)) {
                    this.parseCache(param);
                    continue;
                }
                if ("escape".equals(extension)) {
                    this.parseEscape(param);
                    continue;
                }
                if ("raw".equals(extension)) {
                    this.escape = ITemplate.Escape.RAW;
                    continue;
                }
                if ("callback".equals(extension)) {
                    this.parseCallback(param);
                    continue;
                }
                if ("ignoreNonExistsTag".equals(extension)) {
                    this.ignoreNonExistsTag = true;
                    continue;
                }
                if ("assign".equals(extension)) {
                    this.parseAssign(param);
                    continue;
                }
                CaretParserFactoryBase.raiseParseException(this.ctx, "Unknown tag invocation extension: %s. Currently supported extension: cache, escape, raw, callback, ignoreNonExistsTag", extension);
            }
        }

        private void parseCache(String param) {
            String s;
            this.enableCache = true;
            String[] sa = param.split(",");
            this.cacheDuration = sa.length > 0 ? (S.isEmpty(s = sa[0]) ? "null" : s) : "null";
            CacheParser.validateDurationStr(this.cacheDuration, this.ctx);
            this.cacheArgs = sa.length > 1 ? param.replaceFirst(this.cacheDuration, "") : ", _plUUID";
        }

        private void parseEscape(String param) {
            if (S.isEmpty(param)) {
                this.escape = ITemplate.Escape.HTML;
            } else {
                param = S.stripQuotation(param).trim();
                try {
                    this.escape = ITemplate.Escape.valueOf(param.toUpperCase());
                }
                catch (Exception e) {
                    CaretParserFactoryBase.raiseParseException(this.ctx, "Unknown escape type: %s. Supported escape: RAW, HTML(default), JAVA, JS, JSON, CSV, XML", param);
                }
            }
        }

        private void parseAssign(String param) {
            String[] sa = param.split(",");
            this.assignTo = S.stripQuotation(sa[0]);
            if (S.isEmpty(this.assignTo)) {
                CaretParserFactoryBase.raiseParseException(this.ctx, "assign extension needs a variable name", new Object[0]);
            }
            if (Patterns.RESERVED.matches(this.assignTo)) {
                CaretParserFactoryBase.raiseParseException(this.ctx, "assign variable name is reserved: %s", this.assignTo);
            }
            if (sa.length > 1) {
                this.assignToFinal = Boolean.parseBoolean(sa[1].trim());
            }
        }

        private void parseCallback(String param) {
            if (!this.enableCallback) {
                CaretParserFactoryBase.raiseParseException(this.ctx, "callback extension only apply to tag invocation with body", new Object[0]);
            }
            this.argList = ArgsParser.parseArgDeclaration(param);
        }

        protected String cacheKey() {
            if (null == this.cacheKey) {
                this.cacheKey = !this.isDynamic ? "\"" + UUID.nameUUIDFromBytes(("_RYTHM_TAG_" + this.tagName + this.ctx.getTemplateClass().name()).getBytes()).toString() + "\"" : "\"_RYTHM_TAG_\" + " + this.tagName + " + \"" + this.ctx.getTemplateClass().name() + "\"";
            }
            return this.cacheKey;
        }

        protected boolean needsNewOut() {
            return this.assignTo != null || this.escape != null || this.enableCache;
        }

        @Override
        public void output() {
            if (this.assignTo != null) {
                if (this.assignToFinal) {
                    this.pt("Object ").p(this.assignTo).p("___ = null;");
                } else {
                    this.pt("Object ").p(this.assignTo).p(" = null;");
                }
                this.pline();
            }
            this.pline("{", new Object[0]);
            this.ptline("com.greenlaw110.rythm.runtime.ITag.ParameterList _pl = null; ", new Object[0]);
            if (this.params.pl.size() > 0) {
                this.ptline("_pl = new com.greenlaw110.rythm.runtime.ITag.ParameterList();", new Object[0]);
                for (int i = 0; i < this.params.pl.size(); ++i) {
                    ParameterDeclaration pd = this.params.pl.get(i);
                    this.pt("_pl.add(\"").p(pd.nameDef == null ? "" : pd.nameDef).p("\",").p(pd.valDef).p(");");
                    this.pline();
                }
            }
            if (this.needsNewOut()) {
                this.ptline("Object _r_s = null;", new Object[0]);
                if (this.enableCache) {
                    this.ptline("String _plUUID = null == _pl ? \"\" : _pl.toUUID();", new Object[0]);
                    this.pt("_r_s = _engine().cached(").p(this.cacheKey()).p(this.cacheArgs).p(");");
                    this.pline();
                }
                this.ptline("if (null == _r_s) {", new Object[0]);
                this.p2tline("StringBuilder sbOld = getOut();", new Object[0]);
                this.p2tline("StringBuilder sbNew = new StringBuilder();", new Object[0]);
                this.p2tline("setSelfOut(sbNew);", new Object[0]);
                if (this.ctx.peekInsideBody().booleanValue()) {
                    this.p2t("_invokeTag(").p(this.tagName).p(", _pl, null, self, ").p(this.ignoreNonExistsTag).p(");");
                } else {
                    this.p2t("_invokeTag(").p(this.tagName).p(", _pl, ").p(this.ignoreNonExistsTag).p(");");
                }
                this.pline();
                this.p2tline("_r_s = sbNew.toString();", new Object[0]);
                this.p2tline("setSelfOut(sbOld);", new Object[0]);
                if (this.escape != null) {
                    this.p2tline(String.format("_r_s = com.greenlaw110.rythm.template.ITemplate.Escape.%s.apply(_r_s);", this.escape.name()), new Object[0]);
                }
                if (this.enableCache) {
                    this.p2t("_engine().cache(").p(this.cacheKey()).p(", _r_s, ").p(this.cacheDuration).p(this.cacheArgs).p(");");
                    this.pline();
                }
                this.ptline("}", new Object[0]);
                if (this.assignTo != null) {
                    if (this.assignToFinal) {
                        this.pt(this.assignTo).p("___ = _r_s;");
                    } else {
                        this.pt(this.assignTo).p(" = _r_s;");
                    }
                    this.pline();
                } else {
                    this.ptline("p(_r_s);", new Object[0]);
                }
            } else {
                if (this.ctx.peekInsideBody().booleanValue()) {
                    this.p2t("_invokeTag(").p(this.tagName).p(", _pl, null, self, ").p(this.ignoreNonExistsTag).p(");");
                } else {
                    this.p2t("_invokeTag(").p(this.tagName).p(", _pl, ").p(this.ignoreNonExistsTag).p(");");
                }
                this.pline();
            }
            this.pline("}", new Object[0]);
            if (this.assignTo != null && this.assignToFinal) {
                this.p("final Object ").p(this.assignTo).p(" = ").p(this.assignTo).p("___;");
                this.pline();
            }
        }
    }

    public static class ParameterDeclarationList {
        public List<ParameterDeclaration> pl = new ArrayList<ParameterDeclaration>();

        void addParameterDeclaration(String nameDef, String valDef) {
            this.pl.add(new ParameterDeclaration(nameDef, valDef));
        }

        public String toString() {
            return this.pl.toString();
        }
    }

    public static class ParameterDeclaration {
        public String nameDef;
        public String valDef;

        ParameterDeclaration(String name, String val) {
            if (null != name) {
                if (name.startsWith("\"") || name.startsWith("'")) {
                    name = name.substring(1);
                }
                if (name.endsWith("\"") || name.endsWith("'")) {
                    name = name.substring(0, name.length() - 1);
                }
            }
            this.nameDef = name;
            this.valDef = val;
        }

        public String toString() {
            return String.format("%s:%s", this.nameDef, this.valDef);
        }
    }
}

