/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.IDirective;
import com.greenlaw110.rythm.internal.TemplateParser;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.NotRythmTemplateException;
import com.greenlaw110.rythm.internal.parser.build_in.InvokeTagParser;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.spi.IDialect;
import com.greenlaw110.rythm.spi.ITemplateClassEnhancer;
import com.greenlaw110.rythm.template.JavaTagBase;
import com.greenlaw110.rythm.template.TagBase;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.utils.IImplicitRenderArgProvider;
import com.greenlaw110.rythm.utils.IImportProvider;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CodeBuilder
extends TextBuilder {
    protected ILogger logger = Logger.get(CodeBuilder.class);
    public RythmEngine engine;
    private boolean isNotRythmTemplate = false;
    protected String tmpl;
    private String cName;
    public String includingCName;
    private String pName;
    private String tagName;
    private String initCode = null;
    private String extended;
    private TemplateClass extendedTemplateClass;
    private InvokeTagParser.ParameterDeclarationList extendArgs = null;
    public Set<String> imports = new HashSet<String>();
    private int extendDeclareLineNo = -1;
    public Map<String, RenderArgDeclaration> renderArgs = new LinkedHashMap<String, RenderArgDeclaration>();
    private List<TextBuilder> builders = new ArrayList<TextBuilder>();
    private TemplateParser parser;
    private TemplateClass templateClass;
    private boolean simpleTemplate = false;
    public transient IDialect dialect = null;
    private static Set<String> globalImports = new HashSet<String>();
    private static IImportProvider importProvider = null;
    private Set<InlineTag> inlineTags = new HashSet<InlineTag>();
    private Stack<List<TextBuilder>> inlineTagBodies = new Stack();
    protected boolean logTime = false;
    private Map<String, List<TextBuilder>> macros = new HashMap<String, List<TextBuilder>>();
    private Stack<String> macroStack = new Stack();
    public String buildBody = null;

    public boolean isRythmTemplate() {
        return !this.isNotRythmTemplate;
    }

    private boolean isTag() {
        return null != this.tagName;
    }

    public void setInitCode(String code) {
        if (null != this.initCode) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "@init section already declared.", new Object[0]);
        }
        this.initCode = code;
    }

    protected String extended() {
        String defClass = this.isTag() ? TagBase.class.getName() : TemplateBase.class.getName();
        return null == this.extended ? defClass : this.extended;
    }

    private String extendedResourceMark() {
        TemplateClass tc = this.extendedTemplateClass;
        return null == tc ? "" : String.format("//<extended_resource_key>%s</extended_resource_key>", tc.templateResource.getKey());
    }

    public TemplateClass getExtendedTemplateClass() {
        return this.extendedTemplateClass;
    }

    public TemplateClass getTemplateClass() {
        return this.templateClass;
    }

    public void setSimpleTemplate(int lineNo) {
        if (null != this.extended) {
            throw new ParseException(this.templateClass, lineNo, "Simple template does not allow to extend layout template", new Object[0]);
        }
        this.simpleTemplate = true;
    }

    public CodeBuilder(String template, String className, String tagName, TemplateClass templateClass, RythmEngine engine, IDialect dialect) {
        this.tmpl = template;
        this.tagName = null == tagName ? className : tagName;
        this.cName = className = className.replace('/', '.');
        int i = className.lastIndexOf(46);
        if (-1 < i) {
            this.cName = className.substring(i + 1);
            this.pName = className.substring(0, i);
        }
        this.engine = null == engine ? Rythm.engine : engine;
        this.dialect = dialect;
        this.parser = new TemplateParser(this);
        this.templateClass = templateClass;
        this.simpleTemplate = templateClass.simpleTemplate;
    }

    public void clear() {
        this.out().ensureCapacity(0);
        this.engine = null;
        this.tmpl = null;
        this.cName = null;
        this.pName = null;
        this.tagName = null;
        this.initCode = null;
        this.extended = null;
        this.extendedTemplateClass = null;
        if (null != this.extendArgs) {
            this.extendArgs.pl.clear();
        }
        this.imports.clear();
        this.extendDeclareLineNo = 0;
        this.renderArgs.clear();
        this.builders.clear();
        this.parser = null;
        this.templateClass = null;
        this.simpleTemplate = false;
        this.inlineTags.clear();
        this.inlineTagBodies.clear();
        this.logTime = false;
        this.macros.clear();
        this.macroStack.clear();
        this.buildBody = null;
    }

    public void rewind() {
        this.out().ensureCapacity(0);
        this.initCode = null;
        this.extended = null;
        this.extendedTemplateClass = null;
        if (null != this.extendArgs) {
            this.extendArgs.pl.clear();
        }
        this.imports.clear();
        this.extendDeclareLineNo = 0;
        this.renderArgs.clear();
        this.builders.clear();
        this.simpleTemplate = false;
        this.inlineTags.clear();
        this.inlineTagBodies.clear();
        this.logTime = false;
        this.macros.clear();
        this.macroStack.clear();
        this.buildBody = null;
    }

    public void merge(CodeBuilder codeBuilder) {
        if (null == codeBuilder) {
            return;
        }
        this.imports.addAll(codeBuilder.imports);
        for (InlineTag tag : codeBuilder.inlineTags) {
            this.inlineTags.add(tag.clone(this));
        }
        this.initCode = S.toString(this.initCode) + S.toString(codeBuilder.initCode);
        this.renderArgs.putAll(codeBuilder.renderArgs);
    }

    public String className() {
        return this.cName;
    }

    public String includingClassName() {
        return null == this.includingCName ? this.cName : this.includingCName;
    }

    public static void registerImports(String imports) {
        globalImports.addAll(Arrays.asList(imports.split(",")));
    }

    public static void registerImportProvider(IImportProvider provider) {
        importProvider = provider;
    }

    public void addImport(String imprt) {
        if (!globalImports.contains(imprt)) {
            this.imports.add(imprt);
        }
        if (imprt.endsWith(".*")) {
            imprt = imprt.substring(0, imprt.lastIndexOf(".*"));
            this.templateClass.importPaths.add(imprt);
        }
    }

    public boolean needsPrint(String tagName) {
        return this.templateClass.returnObject(tagName);
    }

    public InlineTag defTag(String tagName, String retType, String signature, String body) {
        InlineTag tag = new InlineTag(tagName = tagName.trim(), retType, signature, body);
        if (this.inlineTags.contains(tag)) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "inline tag already defined: %s", tagName);
        }
        this.inlineTags.add(tag);
        this.inlineTagBodies.push(this.builders);
        this.builders = tag.builders;
        if ("void".equals(tag.retType)) {
            tag.retType = "com.greenlaw110.rythm.template.ITemplate.RawData";
            tag.autoRet = true;
            String code = "StringBuilder __sb = this.getSelfOut();this.setSelfOut(new StringBuilder());";
            this.builders.add(new CodeToken(code, this.parser));
        }
        this.templateClass.setTagType(tagName, tag.retType);
        return tag;
    }

    public void endTag(InlineTag tag) {
        if (this.inlineTagBodies.empty()) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "Unexpected tag definition close", new Object[0]);
        }
        if (tag.autoRet) {
            this.builders.add(new CodeToken("String __s = toString();this.setSelfOut(__sb);return s().raw(__s);", this.parser));
        }
        this.builders = this.inlineTagBodies.pop();
    }

    public String addIncludes(String includes, int lineNo) {
        StringBuilder sb = new StringBuilder();
        for (String s : includes.split("[\\s,;:]+")) {
            sb.append(this.addInclude(s, lineNo));
        }
        return sb.toString();
    }

    public String addInclude(String include, int lineNo) {
        String tagName = this.engine.testTag(include, this.templateClass);
        if (null == tagName) {
            throw new ParseException(this.templateClass, lineNo, "include template not found: %s", include);
        }
        TemplateBase includeTag = (TemplateBase)((Object)this.engine.tags.get(tagName));
        if (includeTag instanceof JavaTagBase) {
            throw new ParseException(this.templateClass, lineNo, "cannot include Java tag: %s", include);
        }
        TemplateClass includeTc = includeTag.getTemplateClass(false);
        includeTc.buildSourceCode(this.includingClassName());
        this.merge(includeTc.codeBuilder);
        this.templateClass.addIncludeTemplateClass(includeTc);
        return includeTc.codeBuilder.buildBody;
    }

    public void setExtended(Class<? extends TemplateBase> c) {
        this.extended = c.getName();
    }

    public void setExtended(String extended, InvokeTagParser.ParameterDeclarationList args, int lineNo) {
        if (this.simpleTemplate) {
            throw new ParseException(this.templateClass, lineNo, "Simple template does not allow to extend layout template", new Object[0]);
        }
        if (null != this.extended) {
            throw new ParseException(this.templateClass, lineNo, "Extended template already declared", new Object[0]);
        }
        String fullName = this.engine.testTag(extended, this.templateClass);
        if (null == fullName) {
            this.setExtended_deprecated(extended, args, lineNo);
            this.logger.warn("Template[%s]: Extended template declaration \"%s\" is deprecated, please switch to the new style \"%s\"", this.templateClass.getKey(), extended, this.engine.resourceManager.getFullTagName(this.extendedTemplateClass));
        } else {
            TemplateBase tb = (TemplateBase)((Object)this.engine.tags.get(fullName));
            TemplateClass tc = tb.getTemplateClass(false);
            this.extended = tc.name();
            this.extendedTemplateClass = tc;
            this.templateClass.extendedTemplateClass = tc;
            this.engine.addExtendRelationship(tc, this.templateClass);
            this.extendArgs = args;
        }
    }

    public void setExtended_deprecated(String extended, InvokeTagParser.ParameterDeclarationList args, int lineNo) {
        ITemplateResource resource;
        if (null != this.extended) {
            throw new IllegalStateException("Extended template already declared");
        }
        TemplateClass tc = null;
        String origin = extended;
        if (!extended.startsWith("/")) {
            ITemplateResource resource2;
            String me = this.templateClass.getKey().toString();
            int pos = me.lastIndexOf("/");
            if (-1 != pos) {
                extended = me.substring(0, pos) + "/" + extended;
            }
            if (null == (tc = this.engine.classes.getByTemplate(extended)) && (resource2 = this.engine.resourceManager.getFileResource(extended)).isValid()) {
                tc = new TemplateClass(resource2, this.engine);
            }
        }
        if (null == tc && !extended.startsWith("/")) {
            tc = this.engine.classes.getByClassName(extended);
        }
        if (null == tc && null == (tc = this.engine.classes.getByTemplate(origin)) && (resource = this.engine.resourceManager.getFileResource(origin)).isValid()) {
            tc = new TemplateClass(resource, this.engine);
        }
        if (null == tc) {
            throw new ParseException(this.templateClass, lineNo, "Cannot find extended template by name \"%s\"", origin);
        }
        this.extended = tc.name();
        this.extendedTemplateClass = tc;
        this.templateClass.extendedTemplateClass = tc;
        this.engine.addExtendRelationship(tc, this.templateClass);
        this.extendArgs = args;
    }

    public void setLogTime() {
        this.logTime = true;
    }

    public void addRenderArgs(RenderArgDeclaration declaration) {
        this.renderArgs.put(declaration.name, declaration);
    }

    public void addRenderArgs(String type, String name) {
        this.renderArgs.put(name, new RenderArgDeclaration(name, type));
    }

    public void pushMacro(String macro) {
        if (this.macros.containsKey(macro)) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "Macro already defined: %s", macro);
        }
        this.macroStack.push(macro);
        this.macros.put(macro, new ArrayList());
    }

    public void popMacro() {
        if (this.macroStack.empty()) {
            throw new ParseException(this.templateClass, this.parser.currentLine(), "no macro found in stack", new Object[0]);
        }
        this.macroStack.pop();
    }

    public boolean hasMacro(String macro) {
        return this.macros.containsKey(macro);
    }

    public List<TextBuilder> getMacro(String macro) {
        List<TextBuilder> list = this.macros.get(macro);
        if (null == list) {
            throw new NullPointerException();
        }
        return list;
    }

    public void addBuilder(TextBuilder builder) {
        if (this.macroStack.empty()) {
            this.builders.add(builder);
        } else {
            String macro = this.macroStack.peek();
            List<TextBuilder> list = this.macros.get(macro);
            if (null == list) {
                list = new ArrayList<TextBuilder>();
                this.macros.put(macro, list);
            }
            list.add(builder);
        }
    }

    String template() {
        return this.tmpl;
    }

    @Override
    public TextBuilder build() {
        try {
            this.parser.parse();
            this.invokeDirectives();
            if (!this.simpleTemplate) {
                this.addDefaultRenderArgs();
            }
            this.pPackage();
            this.pImports();
            this.pClassOpen();
            this.pTagImpl();
            this.pInitCode();
            this.pSetup();
            if (!this.simpleTemplate) {
                this.pExtendInitArgCode();
            }
            this.pRenderArgs();
            this.pInlineTags();
            for (ITemplateClassEnhancer enhancer : this.engine.templateClassEnhancers) {
                this.np(enhancer.sourceCode());
            }
            this.pBuild();
            this.pClassClose();
            return this;
        }
        catch (NotRythmTemplateException e) {
            this.isNotRythmTemplate = true;
            return this;
        }
    }

    private void invokeDirectives() {
        for (TextBuilder b : this.builders) {
            if (!(b instanceof IDirective)) continue;
            ((IDirective)((Object)b)).call();
        }
    }

    private void addDefaultRenderArgs() {
        IImplicitRenderArgProvider p = this.engine.implicitRenderArgProvider;
        if (null == p) {
            return;
        }
        Map<String, ?> defArgs = p.getRenderArgDescriptions();
        for (String name : defArgs.keySet()) {
            Object o = defArgs.get(name);
            String type = o instanceof Class ? ((Class)o).getName() : o.toString();
            this.addRenderArgs(type, name);
        }
    }

    protected void pPackage() {
        if (!S.isEmpty(this.pName)) {
            this.p("package ").p(this.pName).pn(";");
        }
    }

    protected void pImports() {
        IImplicitRenderArgProvider p;
        for (String s : this.imports) {
            if (S.isEmpty(s)) continue;
            this.p("import ").p(s).pn(Character.valueOf(';'));
        }
        for (String s : globalImports) {
            if (S.isEmpty(s)) continue;
            this.p("import ").p(s).pn(Character.valueOf(';'));
        }
        if (null != importProvider) {
            for (String s : importProvider.imports()) {
                if (S.isEmpty(s)) continue;
                this.p("import ").p(s).pn(Character.valueOf(';'));
            }
        }
        if (null != (p = this.engine.implicitRenderArgProvider)) {
            for (String s : p.getImplicitImportStatements()) {
                this.p("import ").p(s).pn(Character.valueOf(';'));
            }
        }
        this.pn("import java.util.*;");
        this.pn("import java.io.*;");
    }

    protected void pClassOpen() {
        this.np("public class ").p(this.cName).p(" extends ").p(this.extended()).p(" {").pn(this.extendedResourceMark());
    }

    protected void pClassClose() {
        this.np("}").pn();
    }

    protected void pRenderArgs() {
        RenderArgDeclaration arg;
        int userDefinedArgNumber;
        RenderArgDeclaration arg2;
        this.pn();
        for (String argName : this.renderArgs.keySet()) {
            arg2 = this.renderArgs.get(argName);
            this.pt("protected ").p(arg2.type).p(" ").p(argName);
            if (null != arg2.defVal) {
                this.p("=").p(arg2.defVal).p(";");
            } else {
                this.p(";");
            }
            this.pn();
        }
        this.pn();
        this.ptn("@SuppressWarnings(\"unchecked\") public void setRenderArgs(java.util.Map<String, Object> args) {");
        for (String argName : this.renderArgs.keySet()) {
            arg2 = this.renderArgs.get(argName);
            this.p2t("if (null != args && args.containsKey(\"").p(argName).p("\")) this.").p(argName).p("=(").p(arg2.type).p(")args.get(\"").p(argName).pn("\");");
        }
        this.p2t("super.setRenderArgs(args);\n\t}\n");
        IImplicitRenderArgProvider p = this.engine.implicitRenderArgProvider;
        int n = this.simpleTemplate ? this.renderArgs.size() : (userDefinedArgNumber = this.renderArgs.size() - (null == p ? 0 : p.getRenderArgDescriptions().size()));
        if (0 < userDefinedArgNumber) {
            this.pn();
            this.ptn("@SuppressWarnings(\"unchecked\") public void setRenderArgs(Object... args) {");
            this.p2tn("int _p = 0, l = args.length;");
            int i = userDefinedArgNumber;
            for (String argName : this.renderArgs.keySet()) {
                RenderArgDeclaration arg3 = this.renderArgs.get(argName);
                this.p2t("if (_p < l) { Object v = args[_p++]; boolean isString = (\"java.lang.String\".equals(\"").p(arg3.type).p("\") || \"String\".equals(\"").p(arg3.type).p("\")); ").p(argName).p(" = (").p(arg3.type).pn(")(isString ? (null == v ? \"\" : v.toString()) : v); }");
                if (--i != 0) continue;
                break;
            }
            this.ptn("}");
        }
        this.pn();
        this.ptn("@SuppressWarnings(\"unchecked\") @Override public void setRenderArg(String name, Object arg) {");
        for (String argName : this.renderArgs.keySet()) {
            arg = this.renderArgs.get(argName);
            this.p2t("if (\"").p(argName).p("\".equals(name)) this.").p(argName).p("=(").p(arg.type).pn(")arg;");
        }
        this.p2t("super.setRenderArg(name, arg);\n\t}\n");
        this.pn();
        this.ptn("@SuppressWarnings(\"unchecked\") public void setRenderArg(int pos, Object arg) {");
        this.p2tn("int _p = 0;");
        for (String argName : this.renderArgs.keySet()) {
            arg = this.renderArgs.get(argName);
            this.p2t("if (_p++ == pos) { Object v = arg; boolean isString = (\"java.lang.String\".equals(\"").p(arg.type).p("\") || \"String\".equals(\"").p(arg.type).p("\")); ").p(argName).p(" = (").p(arg.type).p(")(isString ? (null == v ? \"\" : v.toString()) : v); }").pn();
        }
        this.p2tn("if(0 == pos) setRenderArg(\"arg\", arg);");
        this.ptn("}");
    }

    protected void pExtendInitArgCode() {
        if (null == this.extendArgs || this.extendArgs.pl.size() < 1) {
            return;
        }
        this.pn();
        this.ptn("@Override protected void loadExtendingArgs() {");
        for (int i = 0; i < this.extendArgs.pl.size(); ++i) {
            InvokeTagParser.ParameterDeclaration pd = this.extendArgs.pl.get(i);
            if (S.isEmpty(pd.nameDef)) {
                this.p2t("__parent.setRenderArg(").p(i).p(", ").p(pd.valDef).pn(");");
            } else {
                this.p2t("__parent.setRenderArg(\"").p(pd.nameDef).p("\", ").p(pd.valDef).pn(");");
            }
            if (this.extendDeclareLineNo == -1) continue;
            this.pn(" //line: ").p(this.extendDeclareLineNo);
        }
        this.ptn("}");
    }

    protected void pSetup() {
        if (!this.logTime && this.renderArgs.isEmpty()) {
            return;
        }
        this.pn();
        this.ptn("@Override protected void setup() {");
        if (this.logTime) {
            this.p2tn("_logTime = true;");
        }
        for (String argName : this.renderArgs.keySet()) {
            RenderArgDeclaration arg = this.renderArgs.get(argName);
            this.p2t("if (").p(argName).p(" == null) {");
            this.p(argName).p("=(").p(arg.type).p(")_get(\"").p(argName).p("\");}\n");
        }
        this.ptn("}");
    }

    protected void pInitCode() {
        if (S.isEmpty(this.initCode)) {
            return;
        }
        this.pn();
        this.pt("@Override public void init() {").p(this.initCode).p(";").pn("\n\t}");
    }

    protected void pTagImpl() {
        if (!this.isTag()) {
            return;
        }
        this.pn();
        this.pt("@Override public java.lang.String getName() {\n\t\treturn \"").p(this.tagName).p("\";\n\t}\n");
    }

    protected void pInlineTags() {
        this.pn();
        for (InlineTag tag : this.inlineTags) {
            this.p("\nprotected ").p(tag.retType).p(" ").p(tag.tagName).p(tag.signature).p("{\n");
            boolean isVoid = tag.autoRet;
            StringBuilder sb = this.out();
            if (!isVoid) {
                this.p(tag.body);
            } else {
                for (TextBuilder b : tag.builders) {
                    b.build();
                }
            }
            this.p("\n}");
        }
    }

    protected void pBuild() {
        this.pn();
        this.pn();
        this.ptn("@Override public com.greenlaw110.rythm.utils.TextBuilder build(){");
        this.p2t("out().ensureCapacity(").p(this.tmpl.length()).p(");").pn();
        StringBuilder sb = new StringBuilder();
        StringBuilder old = this.out();
        this.setOut(sb);
        for (TextBuilder b : this.builders) {
            b.build();
        }
        this.buildBody = sb.toString();
        this.setOut(old);
        this.p(this.buildBody);
        this.p("\n\t\treturn this;\n\t}\n");
    }

    public static class InlineTag {
        String tagName;
        String signature;
        String retType = "void";
        String body;
        boolean autoRet = false;
        List<TextBuilder> builders = new ArrayList<TextBuilder>();

        InlineTag(String name, String ret, String sig, String body) {
            this.tagName = name;
            this.signature = sig;
            this.retType = null == ret ? "void" : ret;
            this.body = body;
        }

        InlineTag clone(CodeBuilder newCaller) {
            InlineTag tag = new InlineTag(this.tagName, this.retType, this.signature, this.body);
            tag.builders.clear();
            for (TextBuilder tb : this.builders) {
                TextBuilder newTb = tb.clone(newCaller);
                tag.builders.add(newTb);
            }
            return tag;
        }

        public int hashCode() {
            return (37 + this.tagName.hashCode()) * 31 + this.signature.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InlineTag) {
                InlineTag that = (InlineTag)obj;
                return S.isEqual(that.signature, this.signature) && S.isEqual(that.tagName, this.tagName);
            }
            return false;
        }
    }

    public static class RenderArgDeclaration {
        public String name;
        public String type;
        public String defVal;

        public RenderArgDeclaration(String name, String type) {
            this(name, type, null);
        }

        public RenderArgDeclaration(String name, String type, String defVal) {
            this.name = name;
            this.type = RenderArgDeclaration.typeTransform(type);
            this.defVal = null == defVal ? RenderArgDeclaration.defVal(type) : defVal;
        }

        private static String typeTransform(String type) {
            if ("boolean".equals(type)) {
                return "Boolean";
            }
            if ("int".equals(type)) {
                return "Integer";
            }
            if ("float".equals(type)) {
                return "Float";
            }
            if ("double".equals(type)) {
                return "Double";
            }
            if ("char".equals(type)) {
                return "Character";
            }
            if ("long".equals(type)) {
                return "Long";
            }
            return type;
        }

        private static String defVal(String type) {
            if (type.equals("boolean")) {
                return "false";
            }
            if (type.equals("int")) {
                return "0";
            }
            if (type.equals("long")) {
                return "0L";
            }
            if (type.equals("char")) {
                return "(char)0";
            }
            if (type.equals("byte")) {
                return "(byte)0";
            }
            if (type.equals("short")) {
                return "(short)0";
            }
            if (type.equals("float")) {
                return "0f";
            }
            if (type.equals("double")) {
                return "0d";
            }
            return "null";
        }
    }
}

