/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class MacroParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.MACRO;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = MacroParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @macro statement. Correct usage: @macro(\"macro-name\"){...}", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                final String macro = S.stripBraceAndQuotation(s);
                return new BlockCodeToken("", this.ctx()){

                    @Override
                    public void openBlock() {
                        this.ctx().getCodeBuilder().pushMacro(macro);
                    }

                    @Override
                    public String closeBlock() {
                        this.ctx().getCodeBuilder().popMacro();
                        return "";
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*((?@()))[\\s]*\\{?\\s*";
    }

    public static void main(String[] args) {
        Regex r = new MacroParser().reg(new Rythm());
        if (r.search("@macro(\"JS\") abc")) {
            MacroParser.p(r);
        }
    }
}

