/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.resource;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.resource.ClasspathTemplateResource;
import com.greenlaw110.rythm.resource.FileTemplateResource;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.ITemplateResourceLoader;
import com.greenlaw110.rythm.resource.StringTemplateResource;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TemplateResourceManager {
    private RythmEngine engine;
    private Map<Object, ITemplateResource> cache = new HashMap<Object, ITemplateResource>();
    public ITemplateResourceLoader resourceLoader = null;

    public TemplateResourceManager(RythmEngine engine) {
        this.engine = engine;
    }

    private ITemplateResource cache(ITemplateResource resource) {
        if (resource.isValid()) {
            this.cache.put(resource.getKey(), resource);
        }
        return resource;
    }

    public TemplateClass tryLoadTag(String tagName, TemplateClass tc) {
        if (null != this.resourceLoader) {
            return this.resourceLoader.tryLoadTag(tagName, tc);
        }
        return FileTemplateResource.tryLoadTag(tagName, this.engine);
    }

    public String getFullTagName(TemplateClass tc) {
        if (null != this.resourceLoader) {
            return this.resourceLoader.getFullTagName(tc);
        }
        return FileTemplateResource.getFullTagName(tc, this.engine);
    }

    public ITemplateResource get(File file) {
        return this.cache(new FileTemplateResource(file, this.engine));
    }

    public ITemplateResource get(String str) {
        ITemplateResource resource = this.getFileResource(str);
        if (!resource.isValid()) {
            resource = new StringTemplateResource(str, this.engine);
        }
        return this.cache(resource);
    }

    public ITemplateResource getFileResource(String str) {
        ITemplateResource resource = this.cache.get(str);
        if (null != resource) {
            return resource;
        }
        if (null != this.resourceLoader) {
            resource = this.resourceLoader.load(str);
        }
        if (null != resource) {
            return resource;
        }
        resource = new FileTemplateResource(str, this.engine);
        if (!resource.isValid()) {
            resource = new ClasspathTemplateResource(str);
        }
        return this.cache(resource);
    }
}

