/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play.parsers;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.dialect.DialectBase;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.play.parsers.PlayRythmKeyword;
import com.greenlaw110.rythm.play.utils.StaticRouteResolver;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IKeyword;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import play.exceptions.NoRouteFoundException;

public class UrlReverseLookupParser
extends KeywordParserFactory {
    protected boolean isAbsolute = false;
    private static final ConcurrentMap<String, String> staticRouteMap = new ConcurrentHashMap<String, String>();
    private static final ConcurrentMap<String, String> staticAbsoluteRouteMap = new ConcurrentHashMap<String, String>();

    public IKeyword keyword() {
        return PlayRythmKeyword._U;
    }

    protected String patternStr() {
        return "^(%s%s[ \\t]*((?@())))";
    }

    protected String innerPattern() {
        return "[a-zA-Z_][\\w$_\\.]*(?@())?";
    }

    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            public TextBuilder go() {
                ConcurrentMap routeMap;
                String staticUrl;
                Regex r = UrlReverseLookupParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return null;
                }
                String s = r.stringMatched();
                this.step(s.length());
                s = r.stringMatched(3);
                s = S.stripBraceAndQuotation((String)s);
                if (S.isEmpty((String)s)) {
                    if (UrlReverseLookupParser.this.isAbsolute) {
                        this.raiseParseException("Error parsing @fullUrl() tag, controller action or static assets expected", new Object[0]);
                    } else {
                        this.raiseParseException("Error parsing @url() tag, controller action or static assets expected", new Object[0]);
                    }
                }
                if (null == (staticUrl = (String)(routeMap = UrlReverseLookupParser.this.isAbsolute ? staticAbsoluteRouteMap : staticRouteMap).get(s))) {
                    try {
                        staticUrl = StaticRouteResolver.reverseWithCheck(s, UrlReverseLookupParser.this.isAbsolute);
                    }
                    catch (NoRouteFoundException e) {
                        // empty catch block
                    }
                }
                if (null != staticUrl) {
                    routeMap.put(s, staticUrl);
                    return new Token(staticUrl, this.ctx());
                }
                if (s.startsWith("/") || s.startsWith("\\")) {
                    this.raiseParseException("Static URL lookup failed: %s", new Object[]{s});
                }
                if ((r = new Regex("([a-zA-Z_][\\w$_\\.]*)((?@())?)")).search(s)) {
                    TemplateClass tc;
                    String action = r.stringMatched(1);
                    s = r.substring(2);
                    if (null == s) {
                        s = "";
                    }
                    if (s.startsWith("(")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith(")")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    boolean escapeXML = !(tc = this.ctx().getTemplateClass()).isStringTemplate() && tc.templateResource.getKey().toString().endsWith(".xml");
                    s = new TextBuilder().p((Object)"p(s().raw(new com.greenlaw110.rythm.play.utils.ActionBridge(").p(UrlReverseLookupParser.this.isAbsolute).p((Object)",").p(escapeXML).p((Object)").invokeMethod(\"").p((Object)action).p((Object)"\", new Object[] {").p((Object)s).p((Object)"})));").toString();
                    return new CodeToken(s, this.ctx());
                }
                throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing url reverse lookup", new Object[0]);
            }
        };
    }

    public static void main(String[] args) {
        String s;
        UrlReverseLookupParser p = new UrlReverseLookupParser();
        Regex r = p.reg((DialectBase)new Rythm());
        if (r.search(s = "@url() abc")) {
            System.out.println(r.stringMatched());
            s = r.stringMatched(3);
            System.out.println(">>" + s);
            s = s.substring(1);
            s = s.substring(0, s.length() - 1);
            System.out.println("<<" + s);
            if (s.startsWith("\"") || s.startsWith("'")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"") || s.endsWith("'")) {
                s = s.substring(0, s.length() - 1);
            }
            System.out.println(s);
        }
    }
}

