/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.Patterns;
import com.greenlaw110.rythm.internal.parser.build_in.InvokeTagParser;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RenderSectionParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.RENDER_SECTION;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Matcher m = RenderSectionParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                String s = m.group(1);
                this.step(s.length());
                String section = m.group(4);
                s = this.remain();
                Matcher m0 = InvokeTagParser.P_HEREDOC_SIMBOL.matcher(s);
                Matcher m1 = InvokeTagParser.P_STANDARD_BLOCK.matcher(s);
                if (m0.matches()) {
                    this.ctx().step(m0.group(1).length());
                    return new DefaultSectionToken(section, this.ctx());
                }
                if (m1.matches()) {
                    this.ctx().step(m1.group(1).length());
                    return new DefaultSectionToken(section, this.ctx());
                }
                String code = S.isEmpty(section) ? "_pLayoutContent();" : "_pLayoutSection(\"" + section + "\");";
                return new CodeToken(code, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "(%s%s\\s*[\\s\\(]\"?'?(" + (Object)((Object)Patterns.VarName) + ")?\"?'?\\)?).*";
    }

    public static void main(String[] args) {
        String s = String.format(new RenderSectionParser().patternStr(), "@", Keyword.RENDER_SECTION);
        Pattern p = Pattern.compile(s);
        Matcher m = p.matcher("@render() Hello world");
        if (m.find()) {
            System.out.println(m.group(1));
            System.out.println(m.group(4));
        }
    }

    public class DefaultSectionToken
    extends BlockCodeToken {
        private String section;

        public DefaultSectionToken(String section, IContext context) {
            super(null, context);
            if (S.isEmpty(section)) {
                section = "__CONTENT__";
            }
            this.section = section;
        }

        @Override
        public void output() {
            this.p2t("_startSection(\"").p(this.section).p("\");");
            this.pline();
        }

        @Override
        public String closeBlock() {
            StringBuilder sbNew = new StringBuilder();
            StringBuilder sbOld = this.getOut();
            this.setOut(sbNew);
            this.p2tline("_endSection(true);", new Object[0]);
            if ("__CONTENT__".equals(this.section)) {
                this.p2tline("_pLayoutContent();", new Object[0]);
            } else {
                this.p2t("_pLayoutSection(\"").p(this.section).p("\");");
                this.pline();
            }
            this.setOut(sbOld);
            return sbNew.toString();
        }
    }
}

