/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm;

import com.greenlaw110.rythm.IByteCodeHelper;
import com.greenlaw110.rythm.IHotswapAgent;
import com.greenlaw110.rythm.ITagInvokeListener;
import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.cache.ICacheService;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.exception.TagLoadException;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.internal.compiler.TemplateClassCache;
import com.greenlaw110.rythm.internal.compiler.TemplateClassLoader;
import com.greenlaw110.rythm.internal.compiler.TemplateClassManager;
import com.greenlaw110.rythm.internal.dialect.AutoToString;
import com.greenlaw110.rythm.internal.dialect.DialectManager;
import com.greenlaw110.rythm.internal.dialect.ToString;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.ILoggerFactory;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.ITemplateResourceLoader;
import com.greenlaw110.rythm.resource.StringTemplateResource;
import com.greenlaw110.rythm.resource.TemplateResourceManager;
import com.greenlaw110.rythm.resource.ToStringTemplateResource;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.spi.ExtensionManager;
import com.greenlaw110.rythm.spi.ITemplateClassEnhancer;
import com.greenlaw110.rythm.spi.ITemplateExecutionExceptionHandler;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.template.JavaTagBase;
import com.greenlaw110.rythm.template.TagBase;
import com.greenlaw110.rythm.template.TemplateBase;
import com.greenlaw110.rythm.toString.ToStringOption;
import com.greenlaw110.rythm.toString.ToStringStyle;
import com.greenlaw110.rythm.utils.IDurationParser;
import com.greenlaw110.rythm.utils.IImplicitRenderArgProvider;
import com.greenlaw110.rythm.utils.IImportProvider;
import com.greenlaw110.rythm.utils.IJavaExtension;
import com.greenlaw110.rythm.utils.IO;
import com.greenlaw110.rythm.utils.IRythmListener;
import com.greenlaw110.rythm.utils.RythmProperties;
import com.greenlaw110.rythm.utils.S;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RythmEngine {
    public static final String version = "1.0.0-20121110";
    public static String pluginVersion = "";
    Rythm.ReloadMethod reloadMethod = Rythm.ReloadMethod.RESTART;
    private final ILogger logger = Logger.get(RythmEngine.class);
    public Rythm.Mode mode;
    public final RythmProperties configuration = new RythmProperties();
    public final TemplateResourceManager resourceManager = new TemplateResourceManager(this);
    public final TemplateClassManager classes = new TemplateClassManager(this);
    public TemplateClassLoader classLoader = null;
    public TemplateClassCache classCache = new TemplateClassCache(this);
    public IByteCodeHelper byteCodeHelper = null;
    public IHotswapAgent hotswapAgent = null;
    public boolean logRenderTime = false;
    private boolean loadPreCompiled = false;
    public boolean preCompiling = false;
    public boolean playHost = false;
    public IImplicitRenderArgProvider implicitRenderArgProvider = null;
    public boolean cacheOnProdOnly = true;
    public int defaultTTL = 3600;
    public ICacheService cacheService = null;
    public IDurationParser durationParser = null;
    private boolean refreshOnRender = true;
    private boolean compactMode = true;
    private boolean enableJavaExtensions = true;
    public boolean noFileWrite = false;
    public File tmpDir;
    public File templateHome;
    public File tagHome;
    private File preCompiledHome;
    public FileFilter tagFileFilter;
    public final List<IRythmListener> listeners = new ArrayList<IRythmListener>();
    public final List<ITemplateClassEnhancer> templateClassEnhancers = new ArrayList<ITemplateClassEnhancer>();
    static ThreadLocal<Integer> cceCounter = new ThreadLocal();
    public Set<String> nonExistsTemplates = new HashSet<String>();
    private NonExistsTemplatesChecker nonExistsTemplatesChecker = null;
    public final Map<String, ITag> tags = new HashMap<String, ITag>();
    public final Set<String> non_tags = new HashSet<String>();
    public Set<String> nonExistsTags = new HashSet<String>();
    private DialectManager dm_ = new DialectManager();
    private ExtensionManager em_ = new ExtensionManager(this);
    private Map<TemplateClass, Set<TemplateClass>> extendMap = new HashMap<TemplateClass, Set<TemplateClass>>();

    public boolean reloadByRestart() {
        return this.isDevMode() && this.reloadMethod == Rythm.ReloadMethod.RESTART;
    }

    public boolean reloadByIncClassVersion() {
        return this.isDevMode() && this.reloadMethod == Rythm.ReloadMethod.V_VERSION;
    }

    public boolean loadPreCompiled() {
        return this.loadPreCompiled;
    }

    public boolean classCacheEnabled() {
        return this.preCompiling || this.loadPreCompiled() || !this.noFileWrite && this.reloadByRestart();
    }

    public static String versionSignature() {
        return "1.0.0-20121110-" + pluginVersion;
    }

    public boolean refreshOnRender() {
        return this.refreshOnRender && !this.isProdMode();
    }

    public boolean compactMode() {
        return this.compactMode;
    }

    public boolean enableJavaExtensions() {
        return this.enableJavaExtensions;
    }

    public File preCompiledHome() {
        return this.preCompiledHome;
    }

    public void registerListener(IRythmListener listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(IRythmListener listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        this.listeners.remove(listener);
    }

    public void clearListener() {
        this.listeners.clear();
    }

    public void registerTemplateClassEnhancer(ITemplateClassEnhancer enhancer) {
        if (null == enhancer) {
            throw new NullPointerException();
        }
        if (!this.templateClassEnhancers.contains(enhancer)) {
            this.templateClassEnhancers.add(enhancer);
        }
    }

    public void unregisterTemplateClassEnhancer(ITemplateClassEnhancer enhancer) {
        if (null == enhancer) {
            throw new NullPointerException();
        }
        this.templateClassEnhancers.remove(enhancer);
    }

    public void clearTemplateClassEnhancer() {
        this.templateClassEnhancers.clear();
    }

    public RythmEngine(File templateHome) {
        this(templateHome, null);
    }

    public RythmEngine(File templateHome, File tagHome) {
        this.init();
        this.templateHome = templateHome;
        this.tagHome = tagHome;
    }

    public RythmEngine(Properties userConfiguration) {
        this.init(userConfiguration);
    }

    public RythmEngine() {
        this.init();
    }

    public boolean isSingleton() {
        return Rythm.engine == this;
    }

    public boolean isProdMode() {
        return this.mode == Rythm.Mode.prod;
    }

    public boolean isDevMode() {
        return this.mode != Rythm.Mode.prod;
    }

    private void setConf(String key, Object val) {
        this.configuration.put(key, val);
    }

    private void loadDefConf() {
        this.setConf("rythm.mode", (Object)Rythm.Mode.prod);
        this.setConf("rythm.loader", "file");
        this.setConf("rythm.logJavaSource", false);
    }

    public void init() {
        this.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties conf) {
        ILoggerFactory fact;
        URL url;
        this.loadDefConf();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = Rythm.class.getClassLoader();
        }
        if (null != (url = cl.getResource("rythm.conf"))) {
            InputStream is = null;
            try {
                is = url.openStream();
                this.configuration.load(is);
            }
            catch (Exception e) {
                this.logger.warn(e, "Error loading rythm.conf", new Object[0]);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        if (null != conf) {
            this.configuration.putAll((Map<?, ?>)conf);
        }
        if (null != (fact = this.configuration.getAs("rythm.logger.factory", null, ILoggerFactory.class))) {
            Logger.registerLoggerFactory(fact);
        }
        pluginVersion = this.configuration.getProperty("rythm.pluginVersion", "");
        this.refreshOnRender = this.configuration.getAsBoolean("rythm.resource.refreshOnRender", true);
        this.enableJavaExtensions = this.configuration.getAsBoolean("rythm.enableJavaExtensions", true);
        this.noFileWrite = this.configuration.getAsBoolean("rythm.noFileWrite", false);
        this.logger.debug(">>>>no file write is: %s", this.noFileWrite);
        this.tmpDir = this.noFileWrite ? null : this.configuration.getAsFile("rythm.tmpDir", IO.tmpDir());
        this.logger.debug(">>>>temp dir is: %s", this.tmpDir);
        this.templateHome = this.configuration.getAsFile("rythm.root", null);
        this.tagHome = this.configuration.getAsFile("rythm.tag.root", null);
        this.tagFileFilter = this.configuration.getAsFileFilter("rythm.tag.fileNameFilter", new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
        this.mode = this.configuration.getAsMode("rythm.mode", Rythm.Mode.prod);
        this.compactMode = this.configuration.getAsBoolean("rythm.compactOutput", this.isProdMode());
        this.reloadMethod = this.configuration.getAsReloadMethod("rythm.reloadMethod", Rythm.ReloadMethod.RESTART);
        this.loadPreCompiled = this.configuration.getAsBoolean("rythm.loadPreCompiled", false);
        this.preCompiledHome = this.configuration.getAsFile("rythm.preCompiled.root", null);
        this.logRenderTime = this.configuration.getAsBoolean("rythm.logRenderTime", false);
        if (Rythm.ReloadMethod.V_VERSION == this.reloadMethod) {
            this.logger.warn("Rythm reload method set to increment class version, this will cause template class cache disabled.", new Object[0]);
        }
        this.defaultTTL = this.configuration.getAsInt("rythm.cache.defaultTTL", 3600);
        this.cacheService = this.configuration.getAsCacheService("rythm.cache.service");
        this.cacheService.setDefaultTTL(this.defaultTTL);
        this.durationParser = this.configuration.getAsDurationParser("rythm.cache.durationParser");
        this.cacheOnProdOnly = this.configuration.getAsBoolean("rythm.cache.prodOnly", true);
        cl = this.configuration.getAs("rythm.classLoader.parent", cl, ClassLoader.class);
        this.classLoader = new TemplateClassLoader(cl, this);
        this.classes.clear();
        this.tags.clear();
        this.tags.put("chain", new JavaTagBase(){

            @Override
            protected void call(ITag.ParameterList params, ITag.Body body) {
                body.render(this.getOut(), new Object[0]);
            }
        });
        this.implicitRenderArgProvider = this.configuration.getAs("rythm.implicitRenderArgProvider", null, IImplicitRenderArgProvider.class);
        this.byteCodeHelper = this.configuration.getAs("rythm.classLoader.byteCodeHelper", null, IByteCodeHelper.class);
        this.hotswapAgent = this.configuration.getAs("rythm.classLoader.hotswapAgent", null, IHotswapAgent.class);
        this.playHost = this.configuration.getAsBoolean("rythm.playHost", false);
        Object o = this.configuration.get("rythm.resource.loader");
        if (o instanceof ITemplateResourceLoader) {
            this.resourceManager.resourceLoader = (ITemplateResourceLoader)o;
        } else if (o instanceof String) {
            try {
                this.resourceManager.resourceLoader = (ITemplateResourceLoader)Class.forName((String)o).newInstance();
            }
            catch (Exception e) {
                this.logger.warn("invalid resource loader class", new Object[0]);
            }
        }
        if (null != this.tagHome && this.configuration.getAsBoolean("rythm.tag.autoscan", true).booleanValue()) {
            this.loadTags();
        }
        this.logger.info("Rythm started in %s mode", new Object[]{this.mode});
    }

    public void restart(RuntimeException cause) {
        if (this.isProdMode()) {
            throw cause;
        }
        if (!(cause instanceof ClassReloadException)) {
            this.logger.warn(cause, "restarting rythm engine due to %s", cause.getMessage());
        }
        this.restart();
    }

    private void restart() {
        if (this.isProdMode()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        cl = this.configuration.getAs("rythm.classLoader.parent", cl, ClassLoader.class);
        this.classLoader = new TemplateClassLoader(cl, this);
        ArrayList<String> templateTags = new ArrayList<String>();
        for (String name : this.tags.keySet()) {
            ITag tag = this.tags.get(name);
            if (tag instanceof JavaTagBase) continue;
            templateTags.add(name);
        }
        for (String name : templateTags) {
            this.tags.remove(name);
        }
    }

    public void loadTags(File tagHome) {
        this.tags.clear();
        class FileTraversal {
            FileTraversal() {
            }

            public final void traverse(File f) {
                if (f.isDirectory()) {
                    File[] childs;
                    if (".svn".equals(f.getName())) {
                        return;
                    }
                    this.onDirectory(f);
                    for (File child : childs = f.listFiles()) {
                        this.traverse(child);
                    }
                    return;
                }
                this.onFile(f);
            }

            public void onDirectory(File d) {
            }

            public void onFile(File f) {
                ITag tag;
                if (RythmEngine.this.tagFileFilter.accept(f) && null != (tag = (ITag)RythmEngine.this.getTemplate(f, new Object[0]))) {
                    RythmEngine.this.registerTag(tag);
                }
            }
        }
        new FileTraversal().traverse(tagHome);
        this.logger.info("tags loaded from %s", tagHome);
    }

    private void loadTags() {
        this.loadTags(this.tagHome);
    }

    public ITemplate getTemplate(File template, Object ... args) {
        ITemplate t;
        TemplateClass tc = this.classes.getByTemplate(this.resourceManager.get(template).getKey());
        if (null == tc) {
            tc = new TemplateClass(template, this);
        }
        if (null == (t = tc.asTemplate())) {
            return null;
        }
        try {
            if (1 == args.length && args[0] instanceof Map) {
                t.setRenderArgs((Map)args[0]);
            } else {
                t.setRenderArgs(args);
            }
        }
        catch (ClassCastException ce) {
            if (this.mode.isDev()) {
                Integer I = cceCounter.get();
                if (null == I) {
                    I = 0;
                    cceCounter.set(1);
                } else {
                    Integer n = I;
                    Integer n2 = I = Integer.valueOf(I + 1);
                    cceCounter.set(I);
                }
                if (I > 2) {
                    cceCounter.remove();
                    throw ce;
                }
                this.restart(ce);
                return this.getTemplate(template, args);
            }
            throw ce;
        }
        if (this.mode.isDev()) {
            cceCounter.remove();
        }
        return t;
    }

    public ITemplate getTemplate(String template, Object ... args) {
        TemplateClass tc = this.classes.getByTemplate(template);
        if (null == tc) {
            tc = new TemplateClass(template, this);
        }
        ITemplate t = tc.asTemplate();
        try {
            if (1 == args.length && args[0] instanceof Map) {
                t.setRenderArgs((Map)args[0]);
            } else {
                t.setRenderArgs(args);
            }
            if (this.mode.isDev()) {
                cceCounter.remove();
            }
        }
        catch (ClassCastException ce) {
            if (this.mode.isDev()) {
                Integer I = cceCounter.get();
                if (null == I) {
                    I = 1;
                    cceCounter.set(I);
                } else {
                    Integer n = I;
                    Integer n2 = I = Integer.valueOf(I + 1);
                    cceCounter.set(I);
                }
                if (I > 2) {
                    cceCounter.remove();
                    throw ce;
                }
                this.restart(ce);
                return this.getTemplate(template, args);
            }
            throw ce;
        }
        return t;
    }

    public void preprocess(ITemplate t) {
        IImplicitRenderArgProvider p = this.implicitRenderArgProvider;
        if (null != p) {
            p.setRenderArgs(t);
        }
        for (IRythmListener l : this.listeners) {
            l.onRender(t);
        }
    }

    private String renderTemplate(ITemplate t) {
        return t.render();
    }

    public String render(String template, Object ... args) {
        ITemplate t = this.getTemplate(template, args);
        return this.renderTemplate(t);
    }

    public String renderStr(String template, Object ... args) {
        return this.renderString(template, args);
    }

    public String toString(String template, Object obj) {
        Class<?> argClass = obj.getClass();
        String key = template + argClass;
        TemplateClass tc = this.classes.getByTemplate(key);
        if (null == tc) {
            tc = new TemplateClass((ITemplateResource)new StringTemplateResource(template), this, new ToString(argClass));
            this.classes.tmplIdx.put(key, tc);
        }
        ITemplate t = tc.asTemplate();
        t.setRenderArg(0, obj);
        return t.render();
    }

    public String toString(Object obj) {
        return this.toString(obj, ToStringOption.defaultOption, null);
    }

    public String toString(Object obj, ToStringOption option, ToStringStyle style) {
        Class<?> c = obj.getClass();
        AutoToString.AutoToStringData key = new AutoToString.AutoToStringData(c, option, style);
        TemplateClass tc = this.classes.getByTemplate(key);
        if (null == tc) {
            tc = new TemplateClass((ITemplateResource)new ToStringTemplateResource(key), this, new AutoToString(c, key));
            this.classes.tmplIdx.put(key, tc);
        }
        ITemplate t = tc.asTemplate();
        t.setRenderArg(0, obj);
        return t.render();
    }

    public String commonsToString(Object obj, ToStringOption option, org.apache.commons.lang3.builder.ToStringStyle style) {
        return this.toString(obj, option, ToStringStyle.fromApacheStyle(style));
    }

    public String renderString(String template, Object ... args) {
        TemplateClass tc = this.classes.getByTemplate(template);
        if (null == tc) {
            tc = new TemplateClass(new StringTemplateResource(template), this);
        }
        ITemplate t = tc.asTemplate();
        if (1 == args.length && args[0] instanceof Map) {
            t.setRenderArgs((Map)args[0]);
        } else {
            t.setRenderArgs(args);
        }
        return t.render();
    }

    public String render(File file, Object ... args) {
        ITemplate t = this.getTemplate(file, args);
        return this.renderTemplate(t);
    }

    public String renderIfTemplateExists(String template, Object ... args) {
        if (this.nonExistsTemplates.contains(template)) {
            return "";
        }
        TemplateClass tc = this.classes.getByTemplate(template);
        if (null == tc) {
            ITemplateResource rsrc = this.resourceManager.getFileResource(template);
            if (rsrc.isValid()) {
                tc = new TemplateClass(rsrc, this);
            } else {
                this.nonExistsTemplates.add(template);
                if (this.mode.isDev() && this.nonExistsTemplatesChecker == null) {
                    this.nonExistsTemplatesChecker = new NonExistsTemplatesChecker();
                }
                return "";
            }
        }
        ITemplate t = tc.asTemplate();
        if (1 == args.length && args[0] instanceof Map) {
            t.setRenderArgs((Map)args[0]);
        } else {
            t.setRenderArgs(args);
        }
        return t.render();
    }

    public static void registerJavaExtension(IJavaExtension extension) {
        Token.addExtension(extension);
    }

    public static void registerGlobalImports(String imports) {
        CodeBuilder.registerImports(imports);
    }

    public static void registerGlobalImportProvider(IImportProvider provider) {
        CodeBuilder.registerImportProvider(provider);
    }

    public TemplateClass getTemplateClassFromTagName(String name) {
        TemplateBase tag = (TemplateBase)((Object)this.tags.get(name));
        if (null == tag) {
            return null;
        }
        return tag.getTemplateClass(false);
    }

    public String testTag(String name, TemplateClass tc) {
        String callerName;
        int pos;
        String name0;
        if (Keyword.THIS.toString().equals(name)) {
            return this.resourceManager.getFullTagName(tc);
        }
        if (this.mode.isProd() && this.non_tags.contains(name)) {
            return null;
        }
        boolean isTag = this.tags.containsKey(name);
        if (isTag) {
            return name;
        }
        if (null != tc.importPaths) {
            for (String s : tc.importPaths) {
                name0 = s + "." + name;
                if (!this.tags.containsKey(name0)) continue;
                return name0;
            }
        }
        if (-1 != (pos = (callerName = this.resourceManager.getFullTagName(tc)).lastIndexOf(".")) && this.tags.containsKey(name0 = callerName.substring(0, pos) + "." + name)) {
            return name0;
        }
        try {
            TemplateClass tagTC = this.resourceManager.tryLoadTag(name, tc);
            if (null == tagTC) {
                if (this.mode.isProd()) {
                    this.non_tags.add(name);
                }
                return null;
            }
            String fullName = tagTC.getFullName();
            return fullName;
        }
        catch (TagLoadException e) {
            throw e;
        }
        catch (RythmException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e, "error trying load tag[%s]", name);
            return null;
        }
    }

    public boolean registerTag(ITag tag) {
        String name = tag.getName();
        return this.registerTag(name, tag);
    }

    public boolean registerTag(String name, ITag tag) {
        if (null == tag) {
            throw new NullPointerException();
        }
        if (this.tags.containsKey(name)) {
            return false;
        }
        this.tags.put(name, tag);
        this.logger.trace("tag %s registered", name);
        return true;
    }

    public void invokeTag(String name, ITemplate caller, ITag.ParameterList params, ITag.Body body, ITag.Body context) {
        this.invokeTag(name, caller, params, body, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTag(String name, ITemplate caller, ITag.ParameterList params, ITag.Body body, ITag.Body context, boolean ignoreNonExistsTag) {
        if (this.nonExistsTags.contains(name)) {
            return;
        }
        ITag tag = this.tags.get(name);
        TemplateClass tc = ((TemplateBase)caller).getTemplateClass(true);
        if (null == tag && S.isEqual(name, ((TagBase)caller).getName())) {
            tag = (TagBase)caller;
        }
        if (null == tag) {
            String callerName;
            int pos;
            String name0;
            if (null != tc.importPaths) {
                String s;
                Iterator<String> i$ = tc.importPaths.iterator();
                while (i$.hasNext() && null == (tag = this.tags.get(name0 = (s = i$.next()) + "." + name))) {
                }
            }
            if (null == tag && -1 != (pos = (callerName = this.resourceManager.getFullTagName(tc)).lastIndexOf("."))) {
                name0 = callerName.substring(0, pos) + "." + name;
                tag = this.tags.get(name0);
            }
            if (null == tag) {
                TemplateClass tagC = this.resourceManager.tryLoadTag(name, tc);
                if (null != tagC) {
                    tag = this.tags.get(tagC.getFullName());
                }
                if (null == tag) {
                    if (ignoreNonExistsTag) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("cannot find tag: " + name, new Object[0]);
                        }
                        this.nonExistsTags.add(name);
                        if (this.mode.isDev() && this.nonExistsTemplatesChecker == null) {
                            this.nonExistsTemplatesChecker = new NonExistsTemplatesChecker();
                        }
                        return;
                    }
                    throw new NullPointerException("cannot find tag: " + name);
                }
                tag = (ITag)tag.cloneMe(this, caller);
            }
        }
        if (!(tag instanceof JavaTagBase)) {
            TemplateClass tc0;
            int pos;
            String cn = tag.getClass().getName();
            if (this.reloadByIncClassVersion() && -1 == cn.indexOf("$") && -1 < (pos = cn.lastIndexOf("v"))) {
                cn = cn.substring(0, pos);
            }
            if (null == (tc0 = this.classes.getByClassName(cn))) {
                System.out.println(tag.getClass());
                System.out.println(name);
                System.out.println(cn);
                System.out.println(caller.getClass());
            }
            tag = (ITag)tc0.asTemplate(caller);
        } else {
            tag = (ITag)tag.cloneMe(this, caller);
        }
        if (null != params) {
            if (tag instanceof JavaTagBase) {
                ((JavaTagBase)tag).setRenderArgs(params);
            } else {
                for (int i = 0; i < params.size(); ++i) {
                    ITag.Parameter param = params.get(i);
                    if (null != param.name) {
                        tag.setRenderArg(param.name, param.value);
                        continue;
                    }
                    tag.setRenderArg(i, param.value);
                }
            }
        }
        if (null != body) {
            tag.setRenderArg("_body", (Object)body);
        }
        for (ITagInvokeListener l : this.getExtensionManager().tagInvokeListeners()) {
            l.onInvoke(tag);
        }
        try {
            if (null != context) {
                ((TagBase)tag).setBodyContext(context);
            }
            tag.call();
        }
        catch (Throwable throwable) {
            for (ITagInvokeListener l : this.getExtensionManager().tagInvokeListeners()) {
                try {
                    l.tagInvoked(tag);
                }
                catch (RuntimeException e) {
                    this.logger.error("Error call tagInvoked hook of %s", l.getClass());
                }
            }
            throw throwable;
        }
        for (ITagInvokeListener l : this.getExtensionManager().tagInvokeListeners()) {
            try {
                l.tagInvoked(tag);
            }
            catch (RuntimeException e) {
                this.logger.error("Error call tagInvoked hook of %s", l.getClass());
            }
        }
    }

    public void handleTemplateExecutionException(Exception e, TemplateBase template) throws Exception {
        for (ITemplateExecutionExceptionHandler h : this.em_.exceptionHandlers()) {
            if (!h.handleTemplateExecutionException(e, template)) continue;
            return;
        }
        throw e;
    }

    public void cache(String key, Object o, int ttl, Object ... args) {
        String value;
        if (this.mode.isDev() && this.cacheOnProdOnly) {
            return;
        }
        String string = null == o ? "" : (value = o instanceof Serializable ? (Serializable)o : o.toString());
        if (args.length > 0) {
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append("-").append(arg);
            }
            key = sb.toString();
        }
        this.cacheService.put(key, (Serializable)((Object)value), ttl);
    }

    public void cache(String key, Object o, String duration, Object ... args) {
        int ttl = null == duration ? this.defaultTTL : this.durationParser.parseDuration(duration);
        this.cache(key, o, ttl, args);
    }

    public Serializable cached(String key, Object ... args) {
        if (args.length > 0) {
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append("-").append(arg);
            }
            key = sb.toString();
        }
        return this.cacheService.get(key);
    }

    public void shutdown() {
        if (null != this.cacheService) {
            this.cacheService.shutdown();
        }
    }

    public DialectManager getDialectManager() {
        return this.dm_;
    }

    public ExtensionManager getExtensionManager() {
        return this.em_;
    }

    public void addExtendRelationship(TemplateClass parent, TemplateClass child) {
        if (this.mode.isProd()) {
            return;
        }
        Set<TemplateClass> children = this.extendMap.get(parent);
        if (null == children) {
            children = new HashSet<TemplateClass>();
            this.extendMap.put(parent, children);
        }
        children.add(child);
    }

    public void invalidate(TemplateClass parent) {
        if (this.mode.isProd()) {
            return;
        }
        Set<TemplateClass> children = this.extendMap.get(parent);
        if (null == children) {
            return;
        }
        for (TemplateClass child : children) {
            this.invalidate(child);
            child.reset();
        }
    }

    private class NonExistsTemplatesChecker {
        boolean started = false;
        private ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1);

        NonExistsTemplatesChecker() {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> toBeRemoved = new ArrayList<String>();
                    for (String template : RythmEngine.this.nonExistsTemplates) {
                        ITemplateResource rsrc = RythmEngine.this.resourceManager.getFileResource(template);
                        if (!rsrc.isValid()) continue;
                        toBeRemoved.add(template);
                    }
                    RythmEngine.this.nonExistsTemplates.removeAll(toBeRemoved);
                    toBeRemoved.clear();
                    TemplateClass tc = RythmEngine.this.classes.all().get(0);
                    for (String tag : RythmEngine.this.nonExistsTags) {
                        if (null == RythmEngine.this.resourceManager.tryLoadTag(tag, tc)) continue;
                        toBeRemoved.add(tag);
                    }
                    RythmEngine.this.nonExistsTags.removeAll(toBeRemoved);
                    toBeRemoved.clear();
                }
            }, 0L, 10000L, TimeUnit.MILLISECONDS);
        }
    }
}

