/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.exception;

import com.greenlaw110.rythm.exception.FastRuntimeException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RythmException
extends FastRuntimeException {
    public int javaLineNumber = 0;
    public int templateLineNumber = -1;
    public String errorMessage = "";
    public String originalMessage = "";
    private TemplateClass templateClass = null;
    public String javaSource;
    public String templateSource;
    public String templateName;
    private static final Pattern P = Pattern.compile(".*\\/\\/line:\\s*([0-9]+).*");

    public RythmException(Throwable t, String templateName, String javaSource, String templateSource, int javaLineNumber, int templateLineNumber, String message) {
        super(message, t);
        this.templateName = templateName;
        this.javaSource = javaSource;
        this.templateSource = templateSource;
        this.javaLineNumber = javaLineNumber;
        this.templateLineNumber = templateLineNumber;
        this.originalMessage = message;
        this.errorMessage = message;
        this.resolveTemplateLineNumber();
    }

    public RythmException(String templateName, String javaSource, String templateSource, int javaLineNumber, int templateLineNumber, String message) {
        this(null, templateName, javaSource, templateSource, javaLineNumber, templateLineNumber, message);
    }

    public RythmException(String templateName, String javaSource, String templateSource, int javaLineNumber, String message) {
        this(null, templateName, javaSource, templateSource, javaLineNumber, -1, message);
    }

    public RythmException(Throwable t, TemplateClass tc, int javaLineNumber, int templateLineNumber, String message) {
        super(message, t);
        this.javaLineNumber = javaLineNumber;
        this.templateClass = tc;
        this.templateLineNumber = templateLineNumber;
        this.originalMessage = message;
        this.errorMessage = message;
        this.resolveTemplateLineNumber();
    }

    public RythmException(TemplateClass tc, int javaLineNumber, int templateLineNumber, String message) {
        this(null, tc, javaLineNumber, templateLineNumber, message);
    }

    public RythmException(TemplateClass tc, int javaLineNumber, String message) {
        this(null, tc, javaLineNumber, -1, message);
    }

    private void resolveTemplateLineNumber() {
        String errorLine;
        Matcher m;
        String[] lines;
        if (this.javaLineNumber != -1 && this.templateLineNumber == -1 && this.javaLineNumber < (lines = this.getJavaSource().split("(\\r\\n|\\n\\r|\\n|\\r)")).length && (m = P.matcher(errorLine = lines[this.javaLineNumber - 1])).matches()) {
            this.templateLineNumber = Integer.parseInt(m.group(1));
        }
    }

    public String getJavaSource() {
        if (null != this.javaSource) {
            return this.javaSource;
        }
        return null == this.templateClass.javaSource ? "" : this.templateClass.javaSource;
    }

    public String getTemplateSource() {
        if (null != this.templateSource) {
            return this.templateSource;
        }
        return this.templateClass.templateResource.asTemplateContent();
    }

    public String getTemplateName() {
        if (null != this.templateName) {
            return this.templateName;
        }
        return this.templateClass.getKey().toString();
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }
}

