/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.Arrays;

public class EscapeParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.ESCAPE;
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = EscapeParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return null;
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                s = S.stripBraceAndQuotation(s);
                s = S.isEmpty(s) ? "HTML" : ("JavaScript".equalsIgnoreCase(s) ? "JS" : s.toUpperCase());
                if (Arrays.binarySearch(ITemplate.Escape.stringValues(), s) < 0) {
                    this.raiseParseException("Error parsing @escape statement. Escape parameter expected to be one of %s, found: %s", Arrays.asList(ITemplate.Escape.stringValues()), s);
                }
                s = String.format("__ctx.pushEscape(com.greenlaw110.rythm.template.ITemplate.Escape.%s);", s);
                return new BlockCodeToken(s, this.ctx()){

                    @Override
                    public void openBlock() {
                    }

                    @Override
                    public String closeBlock() {
                        return "__ctx.popEscape();";
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*((?@()))[\\s]+\\{?\\s*";
    }

    public static void main(String[] args) {
        Regex r = new EscapeParser().reg(new Rythm());
        if (r.search("@escape(JS) \nab")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
        }
    }
}

