/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import play.Play;
import play.data.binding.Unbinder;
import play.exceptions.NoRouteFoundException;
import play.exceptions.PlayException;
import play.exceptions.UnexpectedException;
import play.libs.F;
import play.mvc.ActionInvoker;
import play.mvc.Http;
import play.mvc.Router;

public class ActionBridge {
    boolean absolute = false;
    boolean escapeXML = false;
    private static Map<String, F.Tuple<Method, String[]>> _m = new HashMap<String, F.Tuple<Method, String[]>>();

    public ActionBridge(boolean absolute) {
        this.absolute = absolute;
    }

    public ActionBridge(boolean absolute, boolean escapeXML) {
        this.absolute = absolute;
        this.escapeXML = escapeXML;
    }

    public Object _abs() {
        this.absolute = true;
        return this;
    }

    public Router.ActionDefinition invokeMethod(String actionString, Object param) {
        try {
            String action = actionString;
            if (actionString.indexOf(".") < 0) {
                Http.Request request = Http.Request.current();
                if (null != request) {
                    action = request.controller + "." + actionString;
                } else {
                    throw new IllegalArgumentException("Must attach mailer class name to action string in reverse url lookup");
                }
            }
            HashMap r = new HashMap();
            Method actionMethod = null;
            String[] names = null;
            F.Tuple<Method, String[]> v = null;
            if (Play.mode.isProd()) {
                v = _m.get(action);
            }
            if (null == v) {
                actionMethod = (Method)ActionInvoker.getActionMethod((String)action)[1];
                names = (String[])actionMethod.getDeclaringClass().getDeclaredField("$" + actionMethod.getName() + ActionBridge.computeMethodHash(actionMethod.getParameterTypes())).get(null);
                if (Play.mode.isProd()) {
                    _m.put(action, (F.Tuple<Method, String[]>)new F.Tuple((Object)actionMethod, (Object)names));
                }
            } else {
                actionMethod = (Method)v._1;
                names = (String[])v._2;
            }
            if (param instanceof Object[]) {
                Object[] oa = (Object[])param;
                if (names.length < oa.length) {
                    throw new NoRouteFoundException(action, null);
                }
                if (oa.length != 0) {
                    Annotation[] annos = actionMethod.getAnnotations();
                    for (int i = 0; i < oa.length; ++i) {
                        if (oa[i] instanceof Router.ActionDefinition && oa[i] != null) {
                            Unbinder.unBind(r, (Object)oa[i].toString(), (String)(i < names.length ? names[i] : ""), (Annotation[])annos);
                            continue;
                        }
                        if (ActionBridge.isSimpleParam(actionMethod.getParameterTypes()[i])) {
                            if (oa[i] == null) continue;
                            Unbinder.unBind(r, (Object)oa[i].toString(), (String)(i < names.length ? names[i] : ""), (Annotation[])annos);
                            continue;
                        }
                        Unbinder.unBind(r, (Object)oa[i], (String)(i < names.length ? names[i] : ""), (Annotation[])annos);
                    }
                }
            }
            Router.ActionDefinition def = Router.reverse((String)action, r);
            if (this.absolute) {
                def.absolute();
            }
            if (this.escapeXML) {
                def.url = def.url.replace("&", "&amp;");
            }
            return def;
        }
        catch (Exception e) {
            if (e instanceof PlayException) {
                throw (PlayException)e;
            }
            throw new UnexpectedException((Throwable)e);
        }
    }

    static boolean isSimpleParam(Class type) {
        return Number.class.isAssignableFrom(type) || type.equals(String.class) || type.isPrimitive();
    }

    public static Integer computeMethodHash(String[] parameters) {
        StringBuffer buffer = new StringBuffer();
        for (String param : parameters) {
            buffer.append(param);
        }
        Integer hash = buffer.toString().hashCode();
        if (hash < 0) {
            return -hash.intValue();
        }
        return hash;
    }

    public static Integer computeMethodHash(Class<?>[] parameters) {
        String[] names = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> param = parameters[i];
            names[i] = "";
            if (param.isArray()) {
                int level = 1;
                param = param.getComponentType();
                while (param.isArray()) {
                    ++level;
                    param = param.getComponentType();
                }
                names[i] = param.getName();
                for (int j = 0; j < level; ++j) {
                    int n = i;
                    names[n] = names[n] + "[]";
                }
                continue;
            }
            names[i] = param.getName();
        }
        return ActionBridge.computeMethodHash(names);
    }
}

