/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.play.utils;

import com.greenlaw110.rythm.play.VirtualFileTemplateResourceLoader;
import java.util.ArrayList;
import java.util.List;
import play.Play;
import play.vfs.VirtualFile;

public class TemplateClassAppEnhancer {
    public static final String ADD_ON_SRC_FN = "__add_on.src";
    public static final String ADD_ON_IMPORT_FN = "__add_on.import";
    private static List<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource> srcResources = new ArrayList<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource>();
    private static List<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource> importResources = new ArrayList<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource>();
    private static String srcCache = null;
    private static String importCache = null;

    public static void clearCache() {
        srcResources.clear();
        importResources.clear();
    }

    public static boolean changed() {
        boolean changed = false;
        StringBuilder sb = new StringBuilder();
        changed = TemplateClassAppEnhancer.loadResources(ADD_ON_SRC_FN, "rythm.addon.src", srcResources, sb);
        srcCache = sb.toString();
        sb = new StringBuilder();
        if (TemplateClassAppEnhancer.loadResources(ADD_ON_IMPORT_FN, "rythm.addon.import", importResources, sb)) {
            changed = true;
        }
        importCache = sb.toString();
        return changed;
    }

    private static boolean loadResources(String defFileName, String propertyKey, List<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource> cache, StringBuilder stringCache) {
        boolean changed = false;
        String fnDef = defFileName;
        String fn = Play.configuration.getProperty(propertyKey, fnDef);
        StringBuilder sb = new StringBuilder();
        ArrayList<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource> deleted = new ArrayList<VirtualFileTemplateResourceLoader.VirtualFileTemplateResource>();
        for (VirtualFileTemplateResourceLoader.VirtualFileTemplateResource tr : cache) {
            if (tr.exists()) continue;
            deleted.add(tr);
        }
        if (!deleted.isEmpty()) {
            changed = true;
            cache.removeAll(deleted);
        }
        VirtualFile appRoot = (VirtualFile)Play.roots.get(0);
        VirtualFile vf = appRoot.child("app/rythm/" + fn);
        VirtualFileTemplateResourceLoader loader = VirtualFileTemplateResourceLoader.instance;
        if (null != vf && vf.exists()) {
            VirtualFileTemplateResourceLoader.VirtualFileTemplateResource tr = loader.load(vf);
            boolean found = false;
            for (VirtualFileTemplateResourceLoader.VirtualFileTemplateResource tr0 : cache) {
                if (!tr0.equals((Object)tr)) continue;
                if (tr0.refresh()) {
                    changed = true;
                }
                stringCache.append(tr0.asTemplateContent()).append('\n');
                found = true;
            }
            if (!found) {
                changed = true;
                cache.add(tr);
                stringCache.append(tr.asTemplateContent()).append('\n');
            }
        }
        String fullPath = "app/rythm/" + defFileName;
        for (int i = 1; i < Play.roots.size(); ++i) {
            vf = ((VirtualFile)Play.roots.get(i)).child(fullPath);
            if (null == vf || !vf.exists()) continue;
            VirtualFileTemplateResourceLoader.VirtualFileTemplateResource tr = loader.load(vf);
            boolean found = false;
            for (VirtualFileTemplateResourceLoader.VirtualFileTemplateResource tr0 : cache) {
                if (!tr0.equals((Object)tr)) continue;
                if (tr0.refresh()) {
                    changed = true;
                }
                stringCache.append(tr0.asTemplateContent()).append('\n');
                found = true;
            }
            if (found) continue;
            changed = true;
            cache.add(tr);
            stringCache.append(tr.asTemplateContent()).append('\n');
        }
        return changed;
    }

    public static String sourceCode() {
        StringBuilder sb = new StringBuilder();
        TemplateClassAppEnhancer.loadResources(ADD_ON_SRC_FN, "rythm.addon.src", srcResources, sb);
        return sb.toString();
    }

    public static String imports() {
        StringBuilder sb = new StringBuilder();
        TemplateClassAppEnhancer.loadResources(ADD_ON_IMPORT_FN, "rythm.addon.import", importResources, sb);
        return sb.toString().replaceAll("[\\n ]+", ",");
    }
}

