/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.Patterns;
import com.greenlaw110.rythm.internal.parser.build_in.ForEachCodeToken;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;

public class ForEachParser
extends KeywordParserFactory {
    private static final ILogger logger = Logger.get(ForEachParser.class);

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String remain;
                Regex r = ForEachParser.this.reg(this.dialect());
                if (!r.search(remain = this.remain())) {
                    r = new Regex(String.format(ForEachParser.this.patternStr2(), this.dialect().a(), ForEachParser.this.keyword()));
                    if (!r.search(remain)) {
                        this.raiseParseException("Error parsing @for statement, correct usage: @for(Type var: iterable){...}", new Object[0]);
                    }
                    String s = r.stringMatched(2);
                    this.step(r.stringMatched().length());
                    return new BlockCodeToken("for " + s + "{\n\t", this.ctx()){

                        @Override
                        public void openBlock() {
                            this.ctx().pushBreak(IContext.Break.BREAK);
                            this.ctx().pushContinue(IContext.Continue.CONTINUE);
                        }

                        @Override
                        public void output() {
                            super.output();
                        }

                        @Override
                        public String closeBlock() {
                            this.ctx().popBreak();
                            return super.closeBlock();
                        }
                    };
                }
                String s = r.stringMatched(1);
                this.step(s.length());
                String type = r.stringMatched(5);
                String varname = r.stringMatched(6);
                String iterable = r.stringMatched(8);
                if (S.isEmpty(iterable)) {
                    this.raiseParseException("Error parsing @for statement, correct usage: @for(Type var: iterable){...}", new Object[0]);
                }
                return new ForEachCodeToken(type, varname, iterable, this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.EACH;
    }

    protected String patternStr2() {
        return "^%s%s\\s*((?@()))\\s*\\{?\\s*";
    }

    @Override
    protected String patternStr() {
        return "^(%s%s(\\s+|\\s*\\(\\s*)((" + (Object)((Object)Patterns.Type) + ")(\\s+(" + (Object)((Object)Patterns.VarName) + "))?)\\s*\\:\\s*(" + (Object)((Object)Patterns.Expression2) + ")(\\s*\\)?[\\s\\r\\n]*|[\\s\\r\\n]+)\\{?[\\s\\r\\n]*).*";
    }

    public static void main(String[] args) {
        ForEachParser.test2();
    }

    private static void test2() {
        RythmEngine re = new RythmEngine();
        re.recordJavaSourceOnRuntimeError = true;
        re.recordTemplateSourceOnRuntimeError = true;
        String s = "<a href=\"#\">";
        System.out.println(re.render(s, new Object[0]));
    }

    private static void test1() {
        String s = "@args List<String> sa\n@for(String s: sa) @s @ else empty !@  ";
        RythmEngine re = new RythmEngine();
        re.recordJavaSourceOnRuntimeError = true;
        re.recordTemplateSourceOnRuntimeError = true;
        ArrayList<String> sa = new ArrayList<String>();
        System.out.println(re.render(s, sa, null));
        sa.add("yy");
        System.out.println(re.render(s, sa, null));
        s = "@args String[] sa\n@for(String s: sa) @s @ else empty! @";
        System.out.println(re.render(s, new String[]{"a"}, "ss"));
        System.out.println(re.render(s, new String[0], "ss"));
        s = "@args int[] sa\n@for(int s: sa) @s @ else empty! @";
        System.out.println(re.render(s, new int[]{5}, "ss"));
        System.out.println(re.render(s, new int[0], "ss"));
        s = "@args Float[] sa\n@for(Float s: sa) @s @ else empty! @";
        System.out.println(re.render(s, new Float[]{Float.valueOf(5.0f)}, "ss"));
        System.out.println(re.render(s, new Float[0], "ss"));
        s = "@args String x\n@cache() { abc }";
        for (int i = 0; i < 3; ++i) {
            System.out.println(re.render(s, new Object[0]));
        }
    }
}

