/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal;

import com.greenlaw110.rythm.internal.TemplateParser;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.ParserDispatcher;
import com.greenlaw110.rythm.internal.parser.build_in.BlockCloseParser;
import com.greenlaw110.rythm.internal.parser.build_in.ScriptParser;
import com.greenlaw110.rythm.internal.parser.build_in.StringTokenParser;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TemplateTokenizer
implements Iterable<TextBuilder> {
    ILogger logger = Logger.get(TemplateTokenizer.class);
    private IContext ctx;
    private List<IParser> parsers = new ArrayList<IParser>();
    private int lastCursor = 0;

    public TemplateTokenizer(String template, IContext context) {
        this.ctx = context;
        this.parsers.add(new ParserDispatcher(this.ctx));
        this.parsers.add(new BlockCloseParser(this.ctx));
        this.parsers.add(new ScriptParser(this.ctx));
        this.parsers.add(new StringTokenParser(this.ctx));
        this.parsers.add(new ParserBase(this.ctx){

            @Override
            public TextBuilder go() {
                TemplateParser p = (TemplateParser)this.ctx();
                if (TemplateTokenizer.this.lastCursor < p.cursor) {
                    return null;
                }
                String oneStep = p.getRemain().substring(0, 1);
                p.step(1);
                return new Token.StringToken(oneStep, p);
            }
        });
    }

    @Override
    public Iterator<TextBuilder> iterator() {
        return new Iterator<TextBuilder>(){

            @Override
            public boolean hasNext() {
                return TemplateTokenizer.this.ctx.hasRemain();
            }

            @Override
            public TextBuilder next() {
                for (IParser p : TemplateTokenizer.this.parsers) {
                    TextBuilder t = p.go();
                    if (null == t) continue;
                    TemplateTokenizer.this.lastCursor = ((TemplateParser)((TemplateTokenizer)TemplateTokenizer.this).ctx).cursor;
                    return t;
                }
                throw new RuntimeException("Internal error");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

