/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.Token;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockCloseParser
extends ParserBase {
    private static final String PTN = "([\\}]?%s[\\}\\s\\n\\>\\]]).*";

    public BlockCloseParser(IContext context) {
        super(context);
    }

    @Override
    public Token go() {
        String s;
        IContext ctx = this.ctx();
        if (ctx.currentBlock() == null) {
            return null;
        }
        String remain = this.remain();
        if ("@".equals(remain)) {
            s = remain;
        } else {
            Pattern p = Pattern.compile(String.format(PTN, this.a()), 32);
            Matcher m = p.matcher(ctx.getRemain());
            if (!m.matches()) {
                return null;
            }
            s = m.group(1);
        }
        if (s.endsWith(">") || s.endsWith("]")) {
            s = s.substring(0, s.length() - 1);
        }
        ctx.step(s.length());
        boolean hasLineBreak = s.contains("\\n") || s.contains("\\r");
        try {
            s = ctx.closeBlock();
            if (hasLineBreak) {
                s = s + "\n";
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return new CodeToken(s, ctx);
    }

    public static void main(String[] args) {
        String s = "@";
        Pattern p = Pattern.compile(String.format(PTN, "@"), 32);
        Matcher m = p.matcher(s);
        if (m.matches()) {
            System.out.println(m.group(1));
        }
    }
}

