/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.template;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.exception.FastRuntimeException;
import com.greenlaw110.rythm.exception.RythmException;
import com.greenlaw110.rythm.internal.TemplateBuilder;
import com.greenlaw110.rythm.internal.compiler.ClassReloadException;
import com.greenlaw110.rythm.internal.compiler.TemplateClass;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.runtime.ITag;
import com.greenlaw110.rythm.template.ITemplate;
import com.greenlaw110.rythm.utils.IO;
import com.greenlaw110.rythm.utils.S;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class TemplateBase
extends TemplateBuilder
implements ITemplate {
    protected final ILogger logger = Logger.get(TemplateBase.class);
    protected transient RythmEngine engine = null;
    private transient TemplateClass templateClass = null;
    protected Map<String, Object> _properties = new HashMap<String, Object>();
    private String layoutContent = "";
    private Map<String, String> layoutSections = new HashMap<String, String>();
    private Map<String, Object> renderProperties = new HashMap<String, Object>();
    protected TemplateBase __parent = null;
    private StringBuilder tmpOut = null;
    private String section = null;
    private TextBuilder tmpCaller = null;
    private Writer w_ = null;
    public ITemplate.Context __ctx = new ITemplate.Context();
    protected static ILogger _logger = Logger.get(TemplateBase.class);
    protected boolean _logTime = false;

    public void setTemplateClass(TemplateClass templateClass) {
        this.templateClass = templateClass;
        this.__ctx.init(this);
    }

    protected S s() {
        return S.INSTANCE;
    }

    protected RythmEngine r() {
        return this.engine;
    }

    protected RythmEngine _engine() {
        return null == this.engine ? Rythm.engine : this.engine;
    }

    protected void _invokeTag(String name) {
        this.engine.invokeTag(name, this, null, null, null);
    }

    protected void _invokeTag(String name, boolean ignoreNonExistsTag) {
        this.engine.invokeTag(name, this, null, null, null, ignoreNonExistsTag);
    }

    protected void _invokeTag(String name, ITag.ParameterList params) {
        this.engine.invokeTag(name, this, params, null, null);
    }

    protected void _invokeTag(String name, ITag.ParameterList params, boolean ignoreNonExistsTag) {
        this.engine.invokeTag(name, this, params, null, null, ignoreNonExistsTag);
    }

    protected void _invokeTag(String name, ITag.ParameterList params, ITag.Body body) {
        this.engine.invokeTag(name, this, params, body, null);
    }

    protected void _invokeTag(String name, ITag.ParameterList params, ITag.Body body, boolean ignoreNoExistsTag) {
        this.engine.invokeTag(name, this, params, body, null, ignoreNoExistsTag);
    }

    protected void _invokeTag(String name, ITag.ParameterList params, ITag.Body body, ITag.Body context) {
        this.engine.invokeTag(name, this, params, body, context);
    }

    protected void _invokeTag(String name, ITag.ParameterList params, ITag.Body body, ITag.Body context, boolean ignoreNonExistsTag) {
        this.engine.invokeTag(name, this, params, body, context, ignoreNonExistsTag);
    }

    public TemplateBase() {
        Class<?> c = this.getClass();
        Class<?> pc = c.getSuperclass();
        if (TemplateBase.class.isAssignableFrom(pc) && !Modifier.isAbstract(pc.getModifiers())) {
            try {
                this.__parent = (TemplateBase)pc.newInstance();
                this.__parent.setTemplateClass(this._engine().classes.getByClassName(pc.getName()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ITemplate.RawData _render(String template, Object ... args) {
        if (null == template) {
            return new ITemplate.RawData("");
        }
        return S.raw(this.engine.render(template, args));
    }

    protected ITemplate.RawData _render(String template) {
        if (null == template) {
            return new ITemplate.RawData("");
        }
        return S.raw(this.engine.render(template, this._properties));
    }

    protected final void setLayoutContent(String body) {
        this.layoutContent = body;
    }

    private void addLayoutSection(String name, String section, boolean def) {
        if (def && this.layoutSections.containsKey(name)) {
            return;
        }
        this.layoutSections.put(name, section);
    }

    protected void _startSection(String name) {
        if (null == name) {
            throw new NullPointerException("section name cannot be null");
        }
        if (null != this.tmpOut) {
            throw new IllegalStateException("section cannot be nested");
        }
        this.tmpCaller = this._caller;
        this._caller = null;
        this.tmpOut = this._out;
        this._out = new StringBuilder();
        this.section = name;
    }

    protected void _endSection() {
        this._endSection(false);
    }

    protected void _endSection(boolean def) {
        if (null == this.tmpOut && null == this.tmpCaller) {
            throw new IllegalStateException("section has not been started");
        }
        this.addLayoutSection(this.section, this._out.toString(), def);
        this._out = this.tmpOut;
        this._caller = this.tmpCaller;
        this.tmpOut = null;
        this.tmpCaller = null;
    }

    protected void _pLayoutSection(String name) {
        this.p(this.layoutSections.get(name));
    }

    protected ITemplate.RawData _getSection(String name) {
        return S.raw(this.layoutSections.get(name));
    }

    protected ITemplate.RawData _getSection() {
        return S.raw(S.isEmpty(this.layoutContent) ? this.layoutSections.get("__CONTENT__") : this.layoutContent);
    }

    protected void _pLayoutContent() {
        this.p(this._getSection());
    }

    private void addAllLayoutSections(Map<String, String> sections) {
        if (null != sections) {
            this.layoutSections.putAll(sections);
        }
    }

    private void addAllRenderProperties(Map<String, Object> properties) {
        if (null != properties) {
            this.renderProperties.putAll(properties);
        }
    }

    protected TemplateBase internalClone() {
        try {
            return (TemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public ITemplate cloneMe(RythmEngine engine, ITemplate caller) {
        if (null == engine) {
            throw new NullPointerException();
        }
        TemplateBase tmpl = this.internalClone();
        if (tmpl.__parent != null) {
            tmpl.__parent = (TemplateBase)tmpl.__parent.cloneMe(engine, caller);
        }
        tmpl.engine = engine;
        tmpl.templateClass = this.templateClass;
        if (null != caller) {
            tmpl._caller = (TextBuilder)((Object)caller);
        }
        tmpl.__ctx = new ITemplate.Context(this.__ctx);
        if (null != this._out) {
            tmpl._out = new StringBuilder();
        }
        tmpl._properties = new HashMap<String, Object>(this._properties.size());
        tmpl.layoutContent = "";
        tmpl.layoutSections = new HashMap<String, String>();
        tmpl.renderProperties = new HashMap<String, Object>();
        tmpl.section = null;
        tmpl.tmpCaller = null;
        tmpl.tmpOut = null;
        tmpl._logTime = this._logTime;
        return tmpl;
    }

    protected void internalInit() {
        this.loadExtendingArgs();
        this.init();
    }

    protected void setup() {
    }

    protected void loadExtendingArgs() {
    }

    @Override
    public void init() {
    }

    private boolean _logTime() {
        return this._logTime || this.engine.logRenderTime;
    }

    public TemplateClass getTemplateClass(boolean useCaller) {
        TemplateBase caller;
        TemplateClass tc = this.templateClass;
        if (useCaller && null == tc && null != (caller = this.caller())) {
            return caller.getTemplateClass(true);
        }
        return tc;
    }

    @Override
    public final String render() {
        try {
            long l = 0L;
            if (this._logTime()) {
                l = System.currentTimeMillis();
            }
            this.engine.preprocess(this);
            this.setup();
            if (this._logTime()) {
                _logger.debug("< preprocess [%s]: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
                l = System.currentTimeMillis();
            }
            String s = this.internalRender();
            if (this._logTime()) {
                _logger.debug("<<<<<<<<<<<< [%s] total render: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
            }
            return s;
        }
        catch (ClassReloadException e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Cannot hotswap class, try to restart engine...", new Object[0]);
            }
            this.engine.restart(e);
            return this.render();
        }
        catch (ClassCastException e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("ClassCastException found, force refresh template and try again...", new Object[0]);
            }
            TemplateClass tc = this.engine.classes.getByClassName(this.getClass().getName());
            tc.refresh(true);
            ITemplate t = tc.asTemplate();
            return t.render();
        }
    }

    protected void _setOutput(String path) {
        try {
            this.w_ = new BufferedWriter(new FileWriter(path));
        }
        catch (Exception e) {
            throw new FastRuntimeException(e.getMessage());
        }
    }

    protected void _setOutput(File file) {
        try {
            this.w_ = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception e) {
            throw new FastRuntimeException(e.getMessage());
        }
    }

    protected void _setOutput(OutputStream os) {
        this.w_ = new OutputStreamWriter(os);
    }

    protected void _setOutput(Writer w) {
        this.w_ = w;
    }

    protected void internalBuild() {
        this.w_ = null;
        try {
            try {
                long l = 0L;
                if (this._logTime()) {
                    l = System.currentTimeMillis();
                }
                this.internalInit();
                this.build();
                if (this._logTime()) {
                    _logger.debug("<<<<<<<<<<<< [%s] build: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
                }
            }
            catch (RythmException e) {
                throw e;
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String msg = null;
                for (StackTraceElement se : stackTrace) {
                    TemplateClass tc;
                    String cName = se.getClassName();
                    if (!cName.contains("__R_T_C__")) continue;
                    if (cName.indexOf("$") != -1) {
                        cName = cName.substring(0, cName.lastIndexOf("$"));
                    }
                    if (null == (tc = this.engine.classes.getByClassName(cName))) continue;
                    if (null == msg && S.isEmpty(msg = e.getMessage())) {
                        msg = "Rythm runtime exception caused by " + e.getClass().getName();
                    }
                    RythmException re = new RythmException(this.engine, e, tc, se.getLineNumber(), -1, msg);
                    if (this.engine.logSourceInfoOnRuntimeError) {
                        Logger.error("Error executing template: %2$s. \n%1$s\n%2$s", re.javaSourceInfo(), re.templateSourceInfo(), msg);
                    }
                    int lineNo = re.templateLineNumber;
                    String key = tc.getKey().toString();
                    int i = key.indexOf(10);
                    if (i == -1) {
                        i = key.indexOf(13);
                    }
                    if (i > -1) {
                        key = key.substring(0, i - 1) + "...";
                    }
                    if (key.length() > 80) {
                        key = key.substring(0, 80) + "...";
                    }
                    if (lineNo != -1) {
                        StackTraceElement[] newStack = new StackTraceElement[stackTrace.length + 1];
                        newStack[0] = new StackTraceElement(tc.name(), "", key, lineNo);
                        System.arraycopy(stackTrace, 0, newStack, 1, stackTrace.length);
                        re.setStackTrace(newStack);
                    }
                    throw re;
                }
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
        catch (RuntimeException e) {
            try {
                this.engine.restart(e);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
        if (null != this.w_) {
            try {
                IO.writeContent((CharSequence)this.toString(), this.w_);
                this.w_ = null;
            }
            catch (Exception e) {
                Logger.error(e, "failed to write template content to output destination", new Object[0]);
            }
        }
    }

    protected String internalRender() {
        this.internalBuild();
        if (null != this.__parent) {
            this.__parent.setLayoutContent(this.toString());
            this.__parent.addAllLayoutSections(this.layoutSections);
            this.__parent.addAllRenderProperties(this.renderProperties);
            this.__parent._properties.putAll(this._properties);
            return this.__parent.render();
        }
        return this.toString();
    }

    @Override
    public TextBuilder build() {
        return this;
    }

    @Override
    public void setRenderArgs(Map<String, Object> args) {
        this._properties.putAll(args);
    }

    protected void setRenderArgs(ITag.ParameterList params) {
        for (int i = 0; i < params.size(); ++i) {
            ITag.Parameter param = params.get(i);
            if (null != param.name) {
                this.setRenderArg(param.name, param.value);
                continue;
            }
            this.setRenderArg(i, param.value);
        }
    }

    @Override
    public void setRenderArgs(Object ... args) {
    }

    @Override
    public void setRenderArg(String name, Object arg) {
        this._properties.put(name, arg);
    }

    protected final void _set(String name, Object arg) {
        this.setRenderArg(name, arg);
    }

    protected final TemplateBase caller() {
        return null == this._caller ? null : (TemplateBase)this._caller;
    }

    @Override
    public <T> T getRenderArg(String name) {
        Object val = this._properties.get(name);
        return (T)(null != val ? val : (null != this._caller ? this.caller().getRenderArg(name) : null));
    }

    protected final <T> T _get(String name) {
        return this.getRenderArg(name);
    }

    protected final <T> T _getAs(String name, Class<T> c) {
        T o = this.getRenderArg(name);
        if (null == o) {
            return null;
        }
        return o;
    }

    protected final <T> T _getRenderProperty(String name, Object def) {
        Object o = this.renderProperties.get(name);
        return (T)(null == o ? def : o);
    }

    protected final <T> T _getRenderProperty(String name) {
        return this._getRenderProperty(name, null);
    }

    protected final <T> T _getRenderPropertyAs(String name, T def) {
        T o = this._getRenderProperty(name, def);
        return null == o ? def : o;
    }

    protected final void _setRenderProperty(String name, Object val) {
        this.renderProperties.put(name, val);
    }

    protected final void handleTemplateExecutionException(Exception e) {
        try {
            this._engine().handleTemplateExecutionException(e, this);
        }
        catch (RuntimeException e0) {
            throw e0;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public Map<String, Object> getRenderArgs() {
        return new HashMap<String, Object>(this._properties);
    }

    @Override
    public void setRenderArg(int position, Object arg) {
    }

    public final TemplateBase pe(Object o) {
        if (null == o) {
            return this;
        }
        if (o instanceof ITemplate.RawData) {
            return (TemplateBase)this.p(o);
        }
        ITemplate.Escape escape = this.__ctx.currentEscape();
        return this.pe(o, escape);
    }

    @Override
    public final TemplateBase pe(Object o, ITemplate.Escape escape) {
        if (null == o) {
            return this;
        }
        if (o instanceof ITemplate.RawData) {
            return (TemplateBase)this.p(o);
        }
        if (null == escape) {
            escape = this.__ctx.currentEscape();
        }
        return (TemplateBase)super.pe(o, escape);
    }

    protected static void _log(String msg, Object ... args) {
        _logger.info(msg, args);
    }

    protected static void _debug(String msg, Object ... args) {
        _logger.debug(msg, args);
    }

    protected static void _info(String msg, Object ... args) {
        _logger.info(msg, args);
    }

    protected static void _warn(String msg, Object ... args) {
        _logger.error(msg, args);
    }

    protected static void _warn(Throwable t, String msg, Object ... args) {
        _logger.error(t, msg, args);
    }

    protected static void _error(String msg, Object ... args) {
        _logger.error(msg, args);
    }

    protected static void _error(Throwable t, String msg, Object ... args) {
        _logger.error(t, msg, args);
    }

    protected static class _Itr<T>
    implements Iterable<T> {
        private Object _o;
        private int _size = -1;
        private Iterator<T> iterator = null;
        private int cursor = 0;

        public _Itr(T[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((Object[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(int[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((int[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(long[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((long[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(float[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return Float.valueOf(((float[])_Itr.this._o)[_Itr.this.cursor++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(double[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((double[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(short[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((short[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(char[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return Character.valueOf(((char[])_Itr.this._o)[_Itr.this.cursor++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(byte[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((byte[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(boolean[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return _Itr.this.cursor < _Itr.this._size;
                }

                @Override
                public T next() {
                    return ((boolean[])_Itr.this._o)[_Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public _Itr(Iterable<T> tc) {
            this._o = tc;
            if (tc instanceof Collection) {
                this._size = ((Collection)tc).size();
            } else {
                int i = 0;
                Iterator<T> itr = tc.iterator();
                while (itr.hasNext()) {
                    ++i;
                    itr.next();
                }
                this._size = i;
            }
            this.iterator = tc.iterator();
        }

        public int size() {
            return this._size;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

