/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.utils;

import com.greenlaw110.rythm.template.ITemplate;
import java.text.Normalizer;
import org.apache.commons.lang3.StringEscapeUtils;

public class S {
    public static S INSTANCE = new S();
    public static final int IGNORECASE = 4096;
    public static final int IGNORESPACE = 8192;

    public static boolean isEmpty(Object s) {
        return null == s || "".equals(s.toString().trim());
    }

    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }

    public static boolean isNotEmpty(String s) {
        return !S.isEmpty(s);
    }

    public static boolean isEqual(String s1, String s2) {
        return S.isEqual(s1, s2, 0);
    }

    public static boolean isEqual(String s1, String s2, int modifier) {
        if (null == s1) {
            return s2 == null;
        }
        if (null == s2) {
            return false;
        }
        if ((modifier & 0x2000) != 0) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if ((modifier & 0x1000) != 0) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static String toString(Object o) {
        return null == o ? "" : o.toString();
    }

    public static ITemplate.RawData raw(Object s) {
        return new ITemplate.RawData(s);
    }

    public static ITemplate.RawData escape(Object s) {
        return S.escapeHtml(s);
    }

    public static ITemplate.RawData escape(Object s, Object escape) {
        if (S.isEmpty(s)) {
            return ITemplate.RawData.NULL;
        }
        if (S.isEmpty(escape)) {
            return S.escape(s);
        }
        String se = escape.toString();
        if ("json".equalsIgnoreCase(se)) {
            return S.escapeJson(s);
        }
        if ("xml".equalsIgnoreCase(se)) {
            return S.escapeXml(s);
        }
        if ("javascript".equalsIgnoreCase(se) || "js".equalsIgnoreCase(se)) {
            return S.escapeJavaScript(s);
        }
        if ("csv".equalsIgnoreCase(se)) {
            return S.escapeCsv(s);
        }
        if ("java".equalsIgnoreCase(se)) {
            return S.escapeJava(s);
        }
        if ("html".equalsIgnoreCase(se)) {
            return S.escapeHtml(s);
        }
        if ("raw".equalsIgnoreCase(se)) {
            return S.raw(s);
        }
        throw new IllegalArgumentException("Unknown escape scheme: " + se);
    }

    public static ITemplate.RawData escapeHtml(Object s) {
        if (null == s) {
            return ITemplate.RawData.NULL;
        }
        return new ITemplate.RawData(StringEscapeUtils.escapeHtml4((String)s.toString()));
    }

    public static ITemplate.RawData escapeCsv(Object s) {
        if (null == s) {
            return ITemplate.RawData.NULL;
        }
        return new ITemplate.RawData(StringEscapeUtils.escapeCsv((String)s.toString()));
    }

    public static ITemplate.RawData escapeJson(Object s) {
        if (null == s) {
            return ITemplate.RawData.NULL;
        }
        String s0 = s.toString();
        s0 = s0.replaceAll("[\n\r]+", "\\\\\\n").replaceAll("[ \t]+", " ").replaceAll("\"", "\\\\\"");
        return new ITemplate.RawData(s0);
    }

    public static ITemplate.RawData escapeJava(Object s) {
        if (null == s) {
            return ITemplate.RawData.NULL;
        }
        return new ITemplate.RawData(StringEscapeUtils.escapeJava((String)s.toString()));
    }

    public static ITemplate.RawData escapeJavaScript(Object s) {
        if (null == s) {
            return ITemplate.RawData.NULL;
        }
        return new ITemplate.RawData(StringEscapeUtils.escapeEcmaScript((String)s.toString()));
    }

    public static ITemplate.RawData escapeXml(Object s) {
        if (null == s) {
            return ITemplate.RawData.NULL;
        }
        return new ITemplate.RawData(StringEscapeUtils.escapeXml((String)s.toString()));
    }

    public static final String strip(String s, String prefix, String postfix) {
        if (null == s) {
            return "";
        }
        if ((s = s.trim()).startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        if (s.endsWith(postfix)) {
            s = s.substring(0, s.length() - postfix.length());
        }
        return s;
    }

    public static final String stripBrace(String s) {
        return S.strip(s, "(", ")");
    }

    public static final String stripQuotation(String s) {
        if (null == s) {
            return "";
        }
        if ((s = s.trim()).startsWith("\"") || s.startsWith("'")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"") || s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static final String stripBraceAndQuotation(String s) {
        s = S.stripBrace(s);
        s = S.stripQuotation(s);
        return s;
    }

    public static String shrinkSpace(Object s) {
        if (null == s) {
            return "";
        }
        return s.toString().replaceAll("[\r\n]+", "\n").replaceAll("\\s+", "\\s");
    }

    public static String pad(Object obj, Integer size) {
        String str = null == obj ? "" : obj.toString();
        int t = size - str.length();
        for (int i = 0; i < t; ++i) {
            str = str + "&nbsp;";
        }
        return str;
    }

    public static String capitalizeWords(Object obj) {
        if (null == obj) {
            return "";
        }
        String source = obj.toString();
        int prevc = 32;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c != ' ' && prevc == 32) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            prevc = c;
        }
        return sb.toString();
    }

    public static String noAccents(Object obj) {
        if (null == obj) {
            return "";
        }
        String string = obj.toString();
        return Normalizer.normalize(string, Normalizer.Form.NFKC).replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0105\u0103]", "a").replaceAll("[\u00e7\u0107\u010d\u0109\u010b]", "c").replaceAll("[\u010f\u0111\u00f0]", "d").replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0119\u011b\u0115\u0117]", "e").replaceAll("[\u0192\u017f]", "f").replaceAll("[\u011d\u011f\u0121\u0123]", "g").replaceAll("[\u0125\u0127]", "h").replaceAll("[\u00ec\u00ed\u00ee\u00ef\u012b\u0129\u012d\u012f\u0131]", "i").replaceAll("[\u0133\u0135]", "j").replaceAll("[\u0137\u0138]", "k").replaceAll("[\u0142\u013e\u013a\u013c\u0140]", "l").replaceAll("[\u00f1\u0144\u0148\u0146\u0149\u014b]", "n").replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u0151\u014f\u0153]", "o").replaceAll("[\u00de\u00fe]", "p").replaceAll("[\u0155\u0159\u0157]", "r").replaceAll("[\u015b\u0161\u015f\u015d\u0219]", "s").replaceAll("[\u0165\u0163\u0167\u021b]", "t").replaceAll("[\u00f9\u00fa\u00fb\u00fc\u016b\u016f\u0171\u016d\u0169\u0173]", "u").replaceAll("[\u0175]", "w").replaceAll("[\u00fd\u00ff\u0177]", "y").replaceAll("[\u017e\u017c\u017a]", "z").replaceAll("[\u00e6]", "ae").replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0104\u0102]", "A").replaceAll("[\u00c7\u0106\u010c\u0108\u010a]", "C").replaceAll("[\u010e\u0110\u00d0]", "D").replaceAll("[\u00c8\u00c9\u00ca\u00cb\u0112\u0118\u011a\u0114\u0116]", "E").replaceAll("[\u011c\u011e\u0120\u0122]", "G").replaceAll("[\u0124\u0126]", "H").replaceAll("[\u00cc\u00cd\u00ce\u00cf\u012a\u0128\u012c\u012e\u0130]", "I").replaceAll("[\u0134]", "J").replaceAll("[\u0136]", "K").replaceAll("[\u0141\u013d\u0139\u013b\u013f]", "L").replaceAll("[\u00d1\u0143\u0147\u0145\u014a]", "N").replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u0150\u014e]", "O").replaceAll("[\u0154\u0158\u0156]", "R").replaceAll("[\u015a\u0160\u015e\u015c\u0218]", "S").replaceAll("[\u00d9\u00da\u00db\u00dc\u016a\u016e\u0170\u016c\u0168\u0172]", "U").replaceAll("[\u0174]", "W").replaceAll("[\u00dd\u0176\u0178]", "Y").replaceAll("[\u0179\u017d\u017b]", "Z").replaceAll("[\u00df]", "ss");
    }

    public static String slugify(Object obj) {
        return S.slugify(obj, Boolean.TRUE);
    }

    public static String slugify(Object obj, Boolean lowercase) {
        if (null == obj) {
            return "";
        }
        String string = obj.toString();
        string = S.noAccents(string);
        string = string.replaceAll("([a-z])'s([^a-z])", "$1s$2");
        string = string.replaceAll("[^\\w]", "-").replaceAll("-{2,}", "-");
        string.replaceAll("-+$", "").replaceAll("^-+", "");
        return lowercase != false ? string.toLowerCase() : string;
    }

    public static String lowerFirst(Object o) {
        if (null == o) {
            return "";
        }
        String string = o.toString();
        if (string.length() == 0) {
            return string;
        }
        return ("" + string.charAt(0)).toLowerCase() + string.substring(1);
    }

    public static String capFirst(Object o) {
        if (null == o) {
            return "";
        }
        String string = o.toString();
        if (string.length() == 0) {
            return string;
        }
        return ("" + string.charAt(0)).toUpperCase() + string.substring(1);
    }

    public static String capAll(Object o) {
        if (null == o) {
            return "";
        }
        String string = o.toString();
        return S.capitalizeWords(string);
    }

    public static String camelCase(Object obj) {
        if (null == obj) {
            return "";
        }
        String string = obj.toString();
        string = S.noAccents(string);
        string = string.replaceAll("[^\\w ]", "");
        StringBuilder result = new StringBuilder(string.length());
        for (String part : string.split(" ")) {
            result.append(S.capFirst(part));
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String s = "var x = 0; ybc\n\nvar y = 1";
        System.out.println(S.escapeJson(s));
    }
}

