/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.cache;

import com.greenlaw110.rythm.cache.ICacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleCacheService
implements ICacheService {
    public static final SimpleCacheService INSTANCE = new SimpleCacheService();
    private ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1);
    private boolean started = false;
    private ConcurrentHashMap<String, Item> cache_ = new ConcurrentHashMap();
    private int defaultTTL = 60;

    private SimpleCacheService() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList toBeRemoved = new ArrayList();
                for (Map.Entry entry : SimpleCacheService.this.cache_.entrySet()) {
                    int ttl;
                    if ((ttl = ((Item)entry.getValue()).ttl--) > 0 || ttl != 0) continue;
                    toBeRemoved.add(entry.getKey());
                }
                for (String key : toBeRemoved) {
                    SimpleCacheService.this.cache_.remove(key);
                }
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void put(String key, Serializable value, int ttl) {
        Item item;
        if (null == key) {
            throw new NullPointerException();
        }
        if (0 == ttl) {
            ttl = this.defaultTTL;
        }
        if (null == (item = this.cache_.get(key))) {
            Item newItem = new Item(key, value, ttl);
            item = this.cache_.putIfAbsent(key, newItem);
            if (null != item) {
                item.value = value;
                item.ttl = ttl;
            }
        } else {
            item.value = value;
            item.ttl = ttl;
        }
    }

    @Override
    public void put(String key, Serializable value) {
        this.put(key, value, this.defaultTTL);
    }

    @Override
    public Serializable remove(String key) {
        Item item = this.cache_.remove(key);
        return null == item ? null : item.value;
    }

    @Override
    public void clean() {
        this.cache_.clear();
    }

    @Override
    public Serializable get(String key) {
        Item item = this.cache_.get(key);
        return null == item ? null : item.value;
    }

    @Override
    public boolean contains(String key) {
        return this.cache_.contains(key);
    }

    @Override
    public void setDefaultTTL(int ttl) {
        if (ttl == 0) {
            throw new IllegalArgumentException("time to live value couldn't be zero");
        }
        this.defaultTTL = ttl;
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    private static class Item {
        String key;
        Serializable value;
        int ttl;

        Item(String key, Serializable value, int ttl) {
            this.key = key;
            this.value = value;
            this.ttl = ttl;
        }
    }
}

