/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.DialectBase;
import com.greenlaw110.rythm.internal.parser.Directive;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.List;

public class ArgsParser
extends KeywordParserFactory {
    public static final String PATTERN = "\\G[ \\t\\x0B\\f]*,?[ \\t\\x0B\\f]*(([\\sa-zA-Z_][\\w$_\\.]*(?@\\<\\>)?)[ \\t\\x0B\\f]+([a-zA-Z_][\\w$_]*))([ \\t\\x0B\\f]*=[ \\t\\x0B\\f]*([0-9]|'[.]'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))?";

    @Override
    public Keyword keyword() {
        return Keyword.ARGS;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                String matched;
                String key;
                String remain = this.remain();
                if (!remain.startsWith(key = String.format("%s%s ", this.a(), ArgsParser.this.keyword()))) {
                    throw new NullPointerException();
                }
                this.step(key.length());
                remain = this.remain();
                Regex r = ArgsParser.this.reg(this.dialect());
                int step = 0;
                final ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
                while (r.search(remain) && !(matched = r.stringMatched()).startsWith("\n") && !matched.startsWith("\r")) {
                    step += matched.length();
                    String name = r.stringMatched(3);
                    String type = r.stringMatched(2);
                    String defVal = r.stringMatched(5);
                    ral.add(new CodeBuilder.RenderArgDeclaration(name, type, defVal));
                }
                this.step(step);
                char c = this.peek();
                while ((' ' == (c = this.peek()) || ';' == c || '\r' == c || '\n' == c) && ctx.hasRemain()) {
                    this.step(1);
                }
                return new Directive("", this.ctx()){

                    @Override
                    public void call() {
                        for (CodeBuilder.RenderArgDeclaration rd : ral) {
                            this.builder().addRenderArgs(rd);
                        }
                    }
                };
            }
        };
    }

    public static List<CodeBuilder.RenderArgDeclaration> parseArgDeclaration(String s) {
        String matched;
        ArrayList<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
        Regex r = new ArgsParser().reg((DialectBase)Rythm.getDialectManager().get());
        while (r.search(s) && !(matched = r.stringMatched()).startsWith("\n") && !matched.startsWith("\r")) {
            String name = r.stringMatched(3);
            String type = r.stringMatched(2);
            String defVal = r.stringMatched(5);
            ral.add(new CodeBuilder.RenderArgDeclaration(name, type, defVal));
        }
        return ral;
    }

    @Override
    protected String patternStr() {
        return PATTERN;
    }

    protected String patternStr0() {
        return "(%s%s([\\s,]+[a-zA-Z][a-zA-Z0-9_\\.]*(\\<[a-zA-Z][a-zA-Z0-9_\\.,]*\\>)?[\\s]+[a-zA-Z][a-zA-Z0-9_\\.]*)+(;|\\r?\\n)+).*";
    }

    public static void main(String[] args) {
        String m;
        String s = "Exception result\n Not found";
        ArgsParser ap = new ArgsParser();
        Regex r = ap.reg(new com.greenlaw110.rythm.internal.dialect.Rythm());
        System.out.println(r);
        while (r.search(s) && !(m = r.stringMatched()).contains("\n") && !m.contains("\r")) {
            System.out.println("m: " + m.toCharArray()[0]);
            System.out.println("1: " + r.stringMatched(1));
            System.out.println("2: " + r.stringMatched(2));
            System.out.println("3: " + r.stringMatched(3));
            System.out.println("4: " + r.stringMatched(4));
            System.out.println("5: " + r.stringMatched(5));
        }
    }
}

