/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.dialect.Rythm;
import com.greenlaw110.rythm.internal.parser.CodeToken;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class BreakParser
extends KeywordParserFactory {
    private static final String R = "^(%s%s\\s*(\\(\\s*\\))?[\\s;]*)";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new ParserBase(c){

            @Override
            public TextBuilder go() {
                Regex r = BreakParser.this.reg(this.dialect());
                if (r.search(this.remain())) {
                    this.step(r.stringMatched().length());
                    IContext.Break b = this.ctx().peekBreak();
                    if (null == b) {
                        throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Bad @break statement: No loop context", new Object[0]);
                    }
                    return new CodeToken(b.getStatement(), this.ctx());
                }
                throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Bad @break statement found. Correct usage: @break()", new Object[0]);
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.BREAK;
    }

    public static void main(String[] args) {
        String s;
        Regex r = new BreakParser().reg(new Rythm());
        if (r.search(s = "@break()\n\tdd")) {
            System.out.println(r.stringMatched());
            System.out.println(r.stringMatched(1));
        }
    }
}

