/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.exception.ParseException;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.spi.Token;
import com.greenlaw110.rythm.utils.TextBuilder;
import com.stevesoft.pat.Regex;

public class SetParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.SET;
    }

    @Override
    protected String patternStr() {
        return "^(%s%s((?@())))";
    }

    @Override
    public IParser create(IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public TextBuilder go() {
                Regex r = SetParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return null;
                }
                this.step(r.stringMatched().length());
                String s = r.stringMatched(2);
                s = s.substring(1);
                s = s.substring(0, s.length() - 1);
                r = new Regex("((?@\"\")|(?@'')|[a-zA-Z_][\\w_]+)\\s*[=:]\\s*('.'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*)");
                if (!r.search(s)) {
                    throw new ParseException(this.ctx().getTemplateClass(), this.ctx().currentLine(), "Error parsing @set tag. Correct usage: @set(\"name\": val)", new Object[0]);
                }
                s = r.stringMatched(1);
                if (s.startsWith("\"") || s.startsWith("'")) {
                    s = s.substring(1);
                    s = s.substring(0, s.length() - 1);
                }
                final String propName = s;
                final String propVal = r.stringMatched(2);
                return new Token("", this.ctx()){

                    @Override
                    protected void output() {
                        this.p("\n_setRenderProperty(\"").p(propName).p("\",").p(propVal).p(");");
                    }
                };
            }
        };
    }

    public static void main(String[] args) {
        Regex r = new Regex("((?@\"\")|(?@'')|[a-zA-Z_][\\w_]+)\\s*[=:]\\s*('.'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*)");
        String s = " title: title";
        if (r.search(s)) {
            System.out.println("1 " + r.stringMatched(1));
            System.out.println("2 " + r.stringMatched(2));
            System.out.println("3 " + r.stringMatched(3));
        }
    }
}

