/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.resource;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.RythmEngine;
import com.greenlaw110.rythm.resource.ITemplateResource;
import com.greenlaw110.rythm.resource.TemplateResourceBase;
import com.greenlaw110.rythm.utils.IO;
import java.net.URL;

public class ClasspathTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private URL url;
    private String key;

    public ClasspathTemplateResource(String path) {
        this(path, null);
    }

    public ClasspathTemplateResource(String path, RythmEngine engine) {
        super(engine);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null == cl) {
            cl = Rythm.class.getClassLoader();
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.url = cl.getResource(path);
        this.key = path;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String reload() {
        return IO.readContentAsString(this.url);
    }

    @Override
    protected long lastModified() {
        return 0L;
    }

    @Override
    public boolean isValid() {
        return null != this.url;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClasspathTemplateResource) {
            ClasspathTemplateResource that = (ClasspathTemplateResource)obj;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    @Override
    protected long defCheckInterval() {
        return -1L;
    }

    @Override
    protected Long userCheckInterval() {
        return this.engine().configuration.getAsLong("rythm.resource.classpath.interval", null);
    }

    @Override
    public String getSuggestedClassName() {
        return ClasspathTemplateResource.path2CN(this.url.getPath());
    }

    public static void main(String[] args) {
        ClasspathTemplateResource cr = new ClasspathTemplateResource("abc23.x");
        System.out.println(cr.isValid());
    }
}

