/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.utils;

import java.util.regex.Pattern;

public interface IJavaExtension {
    public String extend(String var1, String var2);

    public Pattern pattern1();

    public Pattern pattern2();

    public static class ParameterExtension
    implements IJavaExtension {
        private String waiveName = null;
        private String methodName = null;
        private String signature = null;
        private String fullMethodName = null;
        private Pattern pattern1 = null;
        private Pattern pattern2 = null;

        public ParameterExtension(String waiveName, String name, String signature) {
            this(waiveName, name, signature, String.format("com.greenlaw110.rythm.utils.S.%s", name));
        }

        public ParameterExtension(String waiveName, String name, String signature, String fullName) {
            this.waiveName = waiveName;
            this.methodName = name;
            this.signature = signature;
            this.fullMethodName = fullName;
            this.pattern1 = Pattern.compile(String.format(".*(?<!%s)\\.%s\\s*\\((\\s*%s?\\s*)\\)\\s*$", waiveName, this.methodName, signature));
            this.pattern2 = Pattern.compile(String.format("\\.%s\\s*\\((\\s*%s?\\s*)\\)\\s*$", this.methodName, signature));
        }

        @Override
        public Pattern pattern1() {
            return this.pattern1;
        }

        @Override
        public Pattern pattern2() {
            return this.pattern2;
        }

        @Override
        public String extend(String s, String signature) {
            return String.format("%s(%s, %s)", this.fullMethodName, s, signature);
        }
    }

    public static class VoidParameterExtension
    implements IJavaExtension {
        private String waiveName = null;
        private String methodName = null;
        private String fullMethodName = null;
        private Pattern pattern1 = null;
        private Pattern pattern2 = null;

        public VoidParameterExtension(String waiveName, String name) {
            this(waiveName, name, String.format("com.greenlaw110.rythm.utils.S.%s", name));
        }

        public VoidParameterExtension(String waiveName, String name, String fullName) {
            this.waiveName = waiveName;
            this.methodName = name;
            this.fullMethodName = fullName;
            this.pattern1 = Pattern.compile(String.format(".*(?<!%s)\\.%s\\s*\\(\\s*\\)\\s*$", waiveName, this.methodName));
            this.pattern2 = Pattern.compile(String.format("\\.%s\\s*\\(\\s*\\)\\s*$", this.methodName));
        }

        @Override
        public Pattern pattern1() {
            return this.pattern1;
        }

        @Override
        public Pattern pattern2() {
            return this.pattern2;
        }

        @Override
        public String extend(String s, String signature) {
            return String.format("%s(%s)", this.fullMethodName, s);
        }
    }
}

