/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.utils;

import com.greenlaw110.rythm.Rythm;
import com.greenlaw110.rythm.cache.ICacheService;
import com.greenlaw110.rythm.cache.SimpleCacheService;
import com.greenlaw110.rythm.logger.ILogger;
import com.greenlaw110.rythm.logger.Logger;
import com.greenlaw110.rythm.utils.IDurationParser;
import java.io.File;
import java.io.FileFilter;
import java.util.Properties;
import java.util.regex.Pattern;

public class RythmProperties
extends Properties {
    private ILogger logger = Logger.get(RythmProperties.class);

    public Integer getAsInt(String key, Integer defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String s = o.toString();
        int i = Integer.valueOf(s);
        this.put(key, (Object)i);
        return i;
    }

    public Long getAsLong(String key, Long defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        String s = o.toString();
        long l = Long.valueOf(s);
        this.put(key, (Object)l);
        return l;
    }

    public Boolean getAsBoolean(String key, Boolean defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String s = o.toString();
        boolean b = Boolean.valueOf(s);
        this.put(key, (Object)b);
        return b;
    }

    public File getAsFile(String key, File defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof File) {
            return (File)o;
        }
        String s = o.toString();
        return new File(s);
    }

    public Rythm.Mode getAsMode(String key, Rythm.Mode defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof Rythm.Mode) {
            return (Rythm.Mode)((Object)o);
        }
        String s = o.toString();
        Rythm.Mode mode = Rythm.Mode.valueOf(s);
        this.put(key, (Object)mode);
        return mode;
    }

    public Rythm.ReloadMethod getAsReloadMethod(String key, Rythm.ReloadMethod defMethod) {
        Object o = this.get(key);
        if (null == o) {
            return defMethod;
        }
        if (o instanceof Rythm.ReloadMethod) {
            return (Rythm.ReloadMethod)((Object)o);
        }
        String s = o.toString();
        Rythm.ReloadMethod method = Rythm.ReloadMethod.valueOf(s);
        this.put(key, (Object)method);
        return method;
    }

    public FileFilter getAsFileFilter(String key, FileFilter defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof FileFilter) {
            return (FileFilter)o;
        }
        String s = o.toString();
        final Pattern p = Pattern.compile(s);
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return p.matcher(pathname.getPath()).matches();
            }
        };
    }

    public Pattern getAsPattern(String key, Pattern defVal) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (o instanceof Pattern) {
            return (Pattern)o;
        }
        String s = o.toString();
        Pattern p = Pattern.compile(s);
        this.put(key, p);
        return p;
    }

    public ICacheService getAsCacheService(String key) {
        Object o = this.get(key);
        if (null == o) {
            return SimpleCacheService.INSTANCE;
        }
        if (o instanceof ICacheService) {
            return (ICacheService)o;
        }
        String s = o.toString();
        try {
            ICacheService cache = (ICacheService)Class.forName(s).newInstance();
            return cache;
        }
        catch (Exception e) {
            this.logger.warn("error creating cache service from configuration item: %s.  Default implementation will be used instead", s);
            return SimpleCacheService.INSTANCE;
        }
    }

    public IDurationParser getAsDurationParser(String key) {
        Object o = this.get(key);
        if (null == o) {
            return IDurationParser.DEFAULT_PARSER;
        }
        if (o instanceof IDurationParser) {
            return (IDurationParser)o;
        }
        String s = o.toString();
        try {
            return (IDurationParser)Class.forName(s).newInstance();
        }
        catch (Exception e) {
            this.logger.warn("error creating duration parser from configuration item: %s. Default implementation will be used instead", s);
            return IDurationParser.DEFAULT_PARSER;
        }
    }

    public <T> T getAs(String key, T defVal, Class<T> tc) {
        Object o = this.get(key);
        if (null == o) {
            return defVal;
        }
        if (tc.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }
}

