/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.parser.BlockCodeToken;
import com.greenlaw110.rythm.spi.IContext;

public class ForEachCodeToken
extends BlockCodeToken {
    private String type;
    private String varname;
    private String iterable;
    private int openPos;
    private int closePos;

    public ForEachCodeToken(String type, String varname, String iterable, IContext context) {
        super(null, context);
        if (null == type || null == iterable) {
            throw new NullPointerException();
        }
        this.type = type;
        this.varname = null == varname ? "_" : varname;
        this.iterable = iterable;
        --this.line;
        this.openPos = context.cursor();
        this.ctx.pushBreak(IContext.Break.RETURN);
        this.ctx.pushContinue(IContext.Continue.RETURN);
    }

    @Override
    public void output() {
        String prefix = "_".equals(this.varname) ? "" : this.varname;
        String curClassName = this.ctx.getCodeBuilder().className();
        int bodySize = this.closePos - this.openPos;
        this.p("com.greenlaw110.rythm.runtime.Each.INSTANCE.render(").p(this.iterable);
        this.p(", new com.greenlaw110.rythm.runtime.Each.Looper<").p(this.type).p(">(");
        this.p(curClassName).p(".this,").p(bodySize).p("){");
        this.pline();
        this.pt("public boolean render(final ");
        this.p(this.type).p(" ").p(this.varname).p(", final int ").p(prefix).p("_size, final int ").p(prefix).p("_index, final boolean ");
        this.p(prefix).p("_isOdd, final String ").p(prefix).p("_parity, final boolean ");
        this.p(prefix).p("_isFirst, final boolean ").p(prefix).p("_isLast) { ");
        this.pline();
    }

    @Override
    public String closeBlock() {
        this.ctx.popBreak();
        this.closePos = this.ctx.cursor();
        return "\n\t return true;\n\t}});";
    }
}

