/*
 * Decompiled with CFR 0.152.
 */
package com.greenlaw110.rythm.internal.parser.build_in;

import com.greenlaw110.rythm.internal.CodeBuilder;
import com.greenlaw110.rythm.internal.Keyword;
import com.greenlaw110.rythm.internal.parser.Directive;
import com.greenlaw110.rythm.internal.parser.ParserBase;
import com.greenlaw110.rythm.internal.parser.build_in.KeywordParserFactory;
import com.greenlaw110.rythm.spi.IContext;
import com.greenlaw110.rythm.spi.IParser;
import com.greenlaw110.rythm.utils.TextBuilder;
import java.util.regex.Matcher;

public class ImportParser
extends KeywordParserFactory {
    private static final String R = "(%s%s[\\s]+([a-zA-Z0-9_\\.*,\\s]+)(;|\\r?\\n)+).*";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new ParserBase(c){

            @Override
            public TextBuilder go() {
                Matcher m = ImportParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                String s = m.group(1);
                this.step(s.length());
                s = m.group(2);
                String[] sa = s.split("[,\\s]+");
                CodeBuilder cb = this.builder();
                boolean statik = false;
                for (String imp : sa) {
                    if ("static".equals(imp)) {
                        statik = true;
                        continue;
                    }
                    cb.addImport(statik ? "static " + imp : imp);
                    statik = false;
                }
                return new Directive("", this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.IMPORT;
    }
}

